#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os

from crypta.profile.utils.config import config
from crypta.profile.utils.luigi_utils import ExternalInput
from crypta.profile.utils.segment_utils.builders import RegularSegmentBuilder

WEBMASTER_VERIFIED_HOSTS_TABLE_TEMPLATE = '//home/webmaster/prod/export/archive/webmaster-verified-hosts/webmaster-verified-hosts.{}'


yql_query = """
PRAGMA yt.InferSchema = '1';

$direct_puids = (
    SELECT
        CAST(direct.`uid` AS String) as id
    FROM `{direct_table}` as direct
    INNER JOIN hahn.`{clids_table}` as clids
    USING(ClientID)
);

$webmaster_puids = (
    SELECT
        CAST(webmaster.puid AS String) as id
    FROM (
        SELECT
            Url::GetHost(`host_url`) as host,
            `user_id` as puid
        FROM hahn.`{webmaster_table}`
    ) as webmaster
    INNER JOIN hahn.`{hosts_table}` as hosts
    USING(host)
);

$puids = (
    SELECT DISTINCT id
    FROM (
        SELECT * FROM $direct_puids
        UNION ALL
        SELECT * FROM $webmaster_puids
    )
);

INSERT INTO `{output_table}` WITH TRUNCATE
SELECT
    id,
    'puid' as id_type,
    'ecommerce_owners' as segment_name
FROM $puids
"""


class EcommerceOwners(RegularSegmentBuilder):
    name_segment_dict = {
        'ecommerce_owners': 1315,
    }
    keyword = 549

    def requires(self):
        data_folder = os.path.join(
            config.SEGMENT_EXTERNAL_DATA_FOLDER,
            'ecommerce',
        )

        return {
            'webmaster': ExternalInput(
                WEBMASTER_VERIFIED_HOSTS_TABLE_TEMPLATE.format(
                    self.date.replace('-', '')
                )
            ),
            'direct': ExternalInput(config.DIRECT_USERS),
            'hosts': ExternalInput(
                os.path.join(
                    data_folder,
                    'shops_hosts',
                ),
            ),
            'clids': ExternalInput(
                os.path.join(
                    data_folder,
                    'ecommerce_clids',
                ),
            ),
        }

    def build_segment(self, inputs, output_path):
        self.yql.query(
            yql_query.format(
                webmaster_table=inputs['webmaster'].table,
                direct_table=inputs['direct'].table,
                hosts_table=inputs['hosts'].table,
                clids_table=inputs['clids'].table,
                output_table=output_path,
            ),
            transaction=self.transaction,
        )
