#!/usr/bin/env python
# -*- coding: utf-8 -*-

from crypta.profile.runners.segments.lib.coded_segments.common import deep_visits
from crypta.profile.utils.config import config
from crypta.profile.utils.segment_utils.builders import RegularSegmentBuilder
from crypta.profile.utils.segment_utils.processors import DayProcessor, LogProcessor
from crypta.profile.utils.utils import get_matching_table


name_to_variable = {
    u'Газпром': 'gasprom',
    u'АЗС Газпром': 'gasprom',
    u'Нефтьмагистраль': 'magistral',
    u'АЗС Нефтьмагистраль': 'magistral',
    u'НефтьМагистраль': 'magistral',
    u'Нефтьмагистраль АЗС': 'magistral',
    u'Татнефть': 'tat',
    u'АЗС Татнефть': 'tat',
    u'ТНК': 'tnk',
    u'АЗС ТНК': 'tnk',
    u'Роснефть': 'rosneft',
    u'АЗС Роснефть': 'rosneft',
    u'ННК': 'nnk',
    u'АЗС ННК': 'nnk',
    u'Лукойл': 'lukoil',
    u'АЗС Лукойл': 'lukoil',
    u'Ека': 'eka',
    u'АЗС Ека': 'eka',
    u'Eka': 'eka',
    u'Eka АЗС': 'eka',
    u'АЗС Eka': 'eka',
    u'АЗС ЕКА': 'eka',
    u'ЕКА': 'eka',
    u'ЕКА АЗС': 'eka',
    u'Газпромнефть': 'gasprom',
    u'АЗС Газпромнефть': 'gasprom',
    u'Газпромнефть АЗС': 'gasprom',
    u'Башнефть': 'bash',
    u'АЗС Башнефть': 'bash',
    u'BP': 'bp',
    u'АЗС BP': 'bp',
    u'Shell': 'shell',
    u'АЗС Shell': 'shell',
}

gas_stations_query_template = u"""
$name_to_variable = AsDict(
{name_to_variable}
);

$names = (
    SELECT
        permalink,
        $name_to_variable[name_ru] as name
    FROM `{organization_categories}`
    WHERE
        name_ru IN $name_to_variable AND
        DictLength(SetIntersection(ToSet(Yson::ConvertToUint64List(categories)), AsSet(20272, 20271))) > 0
);

$visits = (
    SELECT
        visits.devid as id,
        names.name as segment_name
    FROM `{deep_visits}` as visits
    INNER JOIN $names as names
    USING(permalink)
    GROUP BY visits.devid, names.name
);

INSERT INTO `{output_table}` WITH TRUNCATE
SELECT visits.id as id,
       'idfa' as id_type,
       visits.segment_name as segment_name
FROM $visits as visits
LEFT SEMI JOIN `{matching_idfa}` as matching
USING(id)

UNION ALL

SELECT visits.id as id,
       'gaid' as id_type,
       visits.segment_name as segment_name
FROM $visits as visits
LEFT SEMI JOIN `{matching_gaid}` as matching
USING(id);

"""


class ProcessedDeepVisitLogForGasStations(DayProcessor):
    def requires(self):
        return deep_visits.org_visits_deep_external_input(self.date)

    def process_day(self, inputs, output_path):

        self.yql.query(
            gas_stations_query_template.format(
                organization_categories=config.ORGANIZATION_CATEGORIES,
                deep_visits=inputs.table,
                matching_idfa=get_matching_table('idfa', 'crypta_id'),
                matching_gaid=get_matching_table('gaid', 'crypta_id'),
                name_to_variable=',\n'.join(
                    [u'("{}", "{}")'.format(key, value)
                     for key, value in name_to_variable.iteritems()]
                ),
                output_table=output_path,
            ),
            transaction=self.transaction,
        )


class GasStations(RegularSegmentBuilder):
    keyword = 557
    number_of_days = 35

    name_segment_dict = {
        'bp': 17031667,
        'shell': 17031670,
        'bash': 17031673,
        'gasprom': 17031676,
        'eka': 17031679,
        'lukoil': 17031682,
        'nnk': 17031685,
        'magistral': 17031688,
        'rosneft': 17031691,
        'tnk': 17031694,
        'tat': 17031697,
    }

    def requires(self):
        return LogProcessor(ProcessedDeepVisitLogForGasStations, self.date, self.number_of_days)

    def build_segment(self, inputs, output_path):

        self.yt.unique(
            inputs.table,
            output_path,
            unique_by=('id', 'id_type', 'segment_name')
        )
