#!/usr/bin/env python
# -*- coding: utf-8 -*-

from crypta.profile.utils.config import config
from crypta.profile.utils.segment_utils.builders import RegularSegmentBuilder
from crypta.profile.utils.luigi_utils import ExternalInput

segment_query_template = u"""
$org_category_to_segment_name = AsDict(
    AsTuple(30774, 'industry_cafe_and_restaurants'),
    AsTuple(30776, 'industry_cafe_and_restaurants'),
    AsTuple(31026, 'fitness'),
);

$org_categories_flattened = (
    SELECT permalink, category
    FROM (
        SELECT permalink, Yson::ConvertToInt64List(categories_with_parents) AS categories
        FROM `{organization_categories}`
    )
    FLATTEN LIST BY categories AS category
);

$permalinks_by_org_category = (
    SELECT DISTINCT permalink, $org_category_to_segment_name[category] AS segment_name
    FROM $org_categories_flattened
    WHERE DictContains($org_category_to_segment_name, category)
);

$categories_by_class = (
    SELECT
        id AS category,
        CASE
            WHEN String::Contains(String::ToLower(_class), 'market') THEN 'retail'
            WHEN String::Contains(String::ToLower(_class), 'shop') THEN 'retail'
            WHEN _class = 'fitness' THEN 'fitness'
            ELSE NULL
        END AS segment_name
    FROM `{rubric}`
    WHERE String::Contains(String::ToLower(_class), 'market')
        OR String::Contains(String::ToLower(_class), 'shop')
        OR _class = 'fitness'
);

$permalinks_by_class = (
    SELECT
        t1.permalink AS permalink,
        t2.segment_name AS segment_name
    FROM $org_categories_flattened AS t1
    INNER JOIN $categories_by_class AS t2
    USING (category)
);

INSERT INTO `{output_table}`
WITH TRUNCATE
SELECT id, id_type, segment_name
FROM (
    SELECT
        CAST(owners.user_id AS String) AS id,
        'puid' AS id_type,
        companies.segment_name AS segment_name
    FROM (
        SELECT *
        FROM $permalinks_by_org_category
        UNION ALL
        SELECT *
        FROM $permalinks_by_class
    ) AS companies
    INNER JOIN `{company_to_owner}` AS owners
    USING(permalink)
    WHERE owners.role IS NOT NULL AND owners.role IN ('owner', 'agent')
)
GROUP BY id, id_type, segment_name
"""


class IndustryRepresentatives(RegularSegmentBuilder):
    keyword = 557

    name_segment_dict = {
        'industry_cafe_and_restaurants': 11585740,
        'retail': 11604217,
        'fitness': 12076858,
    }

    def requires(self):
        return {
            'rubric': ExternalInput(config.SPRAV_RUBRICS),
            'company_to_owner': ExternalInput(config.SPRAV_COMPANY_TO_OWNER),
            'organization_categories': ExternalInput(config.ORGANIZATION_CATEGORIES),
        }

    def build_segment(self, inputs, output_path):
        self.yql.query(
            segment_query_template.format(
                company_to_owner=self.input()['company_to_owner'].table,
                rubric=self.input()['rubric'].table,
                organization_categories=self.input()['organization_categories'].table,
                output_table=output_path,
            ),
            transaction=self.transaction,
        )
