#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os

from crypta.profile.utils.config import config
from crypta.profile.utils.luigi_utils import ExternalInput
from crypta.profile.utils.segment_utils.builders import RegularSegmentBuilder
from crypta.profile.utils.segment_utils.processors import DayProcessor, LogProcessor


station_users_query_template = u"""
INSERT INTO `{output_table}` WITH TRUNCATE
SELECT
    id,
    'puid' AS id_type,
    CASE Model
        WHEN 'linkplay_a98' THEN 'dexp_owners'
        WHEN 'lightcomm' THEN 'irbis_owners'
        WHEN 'yandexmini' THEN 'yandex_mini_station_owners'
        WHEN 'elari_a98' THEN 'elari_owners'
        WHEN 'yandexstation' THEN 'yandex_station_owners'
        WHEN 'Station' THEN 'yandex_station_owners'
        WHEN 'yandexstation_2' THEN 'yandex_max_station_owners'
        WHEN 'jbl_link_music' THEN 'jbl_owners'
        WHEN 'jbl_link_portable' THEN 'jbl_owners'
        WHEN 'prestigio_smart_mate' THEN 'prestigio_owners'
        WHEN 'wk7y' THEN 'lg_owners'
        WHEN 'yandexmodule' THEN 'yandex_module_owners'
        WHEN 'yandexmicro' THEN 'yandex_lite_station_owners'
        WHEN 'yandexmodule_2' THEN 'yandex_module_2_owners'
        WHEN 'yandexmini_2' THEN 'yandex_mini_2_station_owners'
        WHEN 'yandexmidi' THEN 'yandex_2_station_owners'
        ELSE NULL
    END AS segment_name
FROM `{input_table}`
WHERE APIKey == 999537
    AND AccountID IS NOT NULL
    AND Model IS NOT NULL
    AND Model IN (
        'linkplay_a98',
        'lightcomm',
        'yandexmini',
        'elari_a98',
        'yandexstation',
        'Station',
        'yandexstation_2',
        'jbl_link_music',
        'jbl_link_portable',
        'prestigio_smart_mate',
        'wk7y',
        'yandexmodule',
        'yandexmicro',
        'yandexmodule_2',
        'yandexmini_2',
        'yandexmidi',
    )
GROUP BY AccountID AS id, Model
"""


class MetrikaMobileLogForAliceDeviceOwners(DayProcessor):
    def requires(self):
        return ExternalInput(
            os.path.join(
                config.APPMETRICA_YANDEX_EVENTS_LOG_FOLDER,
                self.date,
            ),
        )

    def process_day(self, inputs, output_path):
        self.yql.query(
            query_string=station_users_query_template.format(
                input_table=inputs.table,
                output_table=output_path,
            ),
            transaction=self.transaction,
        )


segment_query_template = """
INSERT INTO `{output_table}` WITH TRUNCATE
SELECT id, id_type, segment_name
FROM `{input_table}`
GROUP BY id, id_type, segment_name
"""


class AliceDeviceOwners(RegularSegmentBuilder):
    name_segment_dict = {
        'yandex_station_owners': 1117,
        'dexp_owners': 1162,
        'irbis_owners': 1163,
        'yandex_mini_station_owners': 1202,
        'elari_owners': 1203,
        'yandex_max_station_owners': 2126,
        'jbl_owners': 2129,
        'prestigio_owners': 2128,
        'lg_owners': 2130,
        'yandex_module_owners': 2131,
        'yandex_lite_station_owners': 2521,
        'yandex_module_2_owners': 2815,
        'yandex_mini_2_station_owners': 2816,
        'yandex_2_station_owners': 3044,
    }

    keyword = 547
    number_of_days = 35

    def requires(self):
        return {
            'station_owners': LogProcessor(
                MetrikaMobileLogForAliceDeviceOwners,
                self.date,
                self.number_of_days,
            ),
        }

    def build_segment(self, inputs, output_path):
        self.yql.query(
            query_string=segment_query_template.format(
                input_table=inputs['station_owners'].table,
                output_table=output_path,
            ),
            transaction=self.transaction,
        )
