#!/usr/bin/env python
# -*- coding: utf-8 -*-

from crypta.profile.utils import luigi_utils
from crypta.profile.utils.config import config
from crypta.profile.utils.segment_utils import builders


DESKTOP_CHROME_USERS = "desktop_chrome_users"
MOBILE_CHROME_USERS = "mobile_chrome_users"
DESKTOP_SAFARI_USERS = "desktop_safari_users"
MOBILE_SAFARI_USERS = "mobile_safari_users"
CHROMIUM_USERS = "chromium_users"


BROWSERS_USERS_QUERY = u"""
$browser_to_segment_name = AsDict(
    AsTuple("chrome", "{desktop_chrome_users}"),
    AsTuple("chromemobile", "{mobile_chrome_users}"),
    AsTuple("safari", "{desktop_safari_users}"),
    AsTuple("mobilesafari", "{mobile_safari_users}"),
    AsTuple("chromium", "{chromium_users}")
);

INSERT INTO `{output_table}` WITH TRUNCATE
SELECT
    id,
    id_type,
    $browser_to_segment_name[browser] AS segment_name
FROM `{input_table}`
WHERE DictContains($browser_to_segment_name, browser)
"""


class BrowsersUsers(builders.RegularSegmentBuilder):
    name_segment_dict = {
        DESKTOP_CHROME_USERS: (549, 2182),
        MOBILE_CHROME_USERS: (549, 2183),
        DESKTOP_SAFARI_USERS: (549, 2262),
        MOBILE_SAFARI_USERS: (549, 2263),
        CHROMIUM_USERS: (549, 2264),
    }

    indevice = True

    def requires(self):
        return luigi_utils.ExternalInput(config.YUID_WITH_ALL_INFO_TABLE)

    def build_segment(self, inputs, output_path):
        self.yql.query(
            query_string=BROWSERS_USERS_QUERY.format(
                input_table=inputs.table,
                output_table=output_path,
                desktop_chrome_users=DESKTOP_CHROME_USERS,
                mobile_chrome_users=MOBILE_CHROME_USERS,
                desktop_safari_users=DESKTOP_SAFARI_USERS,
                mobile_safari_users=MOBILE_SAFARI_USERS,
                chromium_users=CHROMIUM_USERS,
            ),
            transaction=self.transaction,
        )
