#!/usr/bin/env python
# -*- coding: utf-8 -*-

from crypta.profile.utils.luigi_utils import ExternalInput
from crypta.profile.utils.segment_utils.builders import (
    LaLParams,
    RegularSegmentBuilder,
)
from crypta.profile.utils.utils import get_matching_table

EDA_PLACES_INFO = '//home/eda-dwh/ods/bigfood/place/place'

yql_query_template = u"""
$segment = (
    SELECT
        lpr_email AS id,
        'email' AS id_type,
        'eda_decision_makers' AS segment_name
    FROM `{input_table}`
    WHERE
        `deleted_flg` == False
        AND `disable_details_status` IS NULL
        AND `lpr_email` IS NOT NULL
    GROUP BY lpr_email
);

INSERT INTO `{output_table}` WITH TRUNCATE
SELECT * FROM $segment;

INSERT INTO `{sample_table}` WITH TRUNCATE
SELECT
    matching.target_id AS yandexuid,
    'eda_decision_makers' As segment_name
FROM `{email_yandexuid}` AS matching
LEFT SEMI JOIN $segment AS segment
USING(id);
"""


class EdaDecisionMakers(RegularSegmentBuilder):
    keyword = 557
    name_segment_dict = {
        'eda_decision_makers': 17832892,
    }

    def requires(self):
        return ExternalInput(EDA_PLACES_INFO)

    def build_segment(self, inputs, output_path):
        with self.yt.TempTable() as sample_table:
            self.yql.query(
                yql_query_template.format(
                    input_table=self.input().table,
                    output_table=output_path,
                    sample_table=sample_table,
                    email_yandexuid=get_matching_table('email', 'yandexuid', indevice=True),
                ),
                transaction=self.transaction,
            )

            self.prepare_samples_for_lal(
                input_table=sample_table,
                id_field='yandexuid',
                lals_params=[LaLParams(
                    name='eda_decision_makers',
                    id=17832895,
                    type='audience_segments',
                    coverage=1000000,
                    include_input=False,
                )],
            )
