#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os

from crypta.profile.utils.luigi_utils import ExternalInput
from crypta.profile.utils.segment_utils.builders import RegularSegmentBuilder


plus_card_owners_query_template = u"""
INSERT INTO `{output_table}` WITH TRUNCATE
SELECT passport_uid AS id, 'puid' AS id_type, 'plus_card_owners' AS segment_name
FROM `{input_table}`
GROUP BY passport_uid
"""


class PlusCardOwners(RegularSegmentBuilder):
    name_segment_dict = {
        'plus_card_owners': (549, 1177),
    }

    def requires(self):
        return ExternalInput(
            os.path.join(
                '//home/plus_data/card_request_report',
                self.date,
            ),
        )

    def build_segment(self, inputs, output_path):
        self.yql.query(
            query_string=plus_card_owners_query_template.format(
                input_table=inputs.table,
                output_table=output_path,
            ),
            transaction=self.transaction,
        )
