#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os

from crypta.profile.utils.config import config
from crypta.profile.utils.luigi_utils import ExternalInput
from crypta.profile.utils.segment_utils.builders import RegularSegmentBuilder


plus_year_subscribers_query = u'''
$current_year_subscriptions = ($start, $end) -> {{
    $this_start_year = 2020;
    $subscription_start_year = DateTime::GetYear(cast($start AS date));
    $one_year_passed = DateTime::MakeDate(DateTime::ShiftYears(cast($start AS date), 1)) == cast($end as date);

    RETURN ($subscription_start_year == $this_start_year) AND $one_year_passed;
}};

$target_bundle = 'new-plus'; -- Плюс / Плюс Мульти

INSERT INTO `{output_table}` WITH TRUNCATE

SELECT
    puid AS id, 'puid' AS id_type, 'plus_year_subscribers' AS segment_name
FROM `{input_table}`
WHERE
    $current_year_subscriptions(start_date, end_date) AND bundle = $target_bundle AND state = 'active';
'''


class PlusYearSubscribers(RegularSegmentBuilder):
    name_segment_dict = {
        'plus_year_subscribers': (549, 2124),
    }

    def requires(self):
        return ExternalInput(os.path.join(config.SUBSCRIBERS_CUBE, self.date))

    def build_segment(self, inputs, output_path):
        self.yql.query(
            query_string=plus_year_subscribers_query.format(
                input_table=inputs.table,
                output_table=output_path,
            ),
            transaction=self.transaction,
        )
