#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os

from crypta.profile.utils.luigi_utils import ExternalInput
from crypta.profile.utils.segment_utils.builders import RegularSegmentBuilder


puids_with_cards_query = """
INSERT INTO `{output_table}` WITH TRUNCATE
SELECT
    CAST(uid as String) as id,
    'puid' as id_type,
    'has_cards' as segment_name
FROM `{input_table}`
WHERE has_cards OR has_own_cards OR has_cards_by_linking;
"""


class PuidsWithCards(RegularSegmentBuilder):
    keyword = 549
    name_segment_dict = {
        'has_cards': (549, 1614),
    }

    def requires(self):
        return ExternalInput(os.path.join('//home/passport/production/cards/uids_has_cards', self.date))

    def build_segment(self, inputs, output_path):

        self.yql.query(
            query_string=puids_with_cards_query.format(
                input_table=inputs.table,
                output_table=output_path,
            ),
            transaction=self.transaction,
        )
