#!/usr/bin/env python
# -*- coding: utf-8 -*-
from crypta.profile.utils.config import config
from crypta.profile.utils.luigi_utils import ExternalInput
from crypta.profile.utils.segment_utils.builders import (
    LaLParams,
    RegularSegmentBuilder,
)
from crypta.profile.utils.utils import get_matching_table


yql_query_template = u"""
$segment = (
    SELECT
        id,
        'puid' AS id_type,
        'spravochnik_users' AS segment_name
    FROM (
        SELECT CAST(user_id AS String) AS id
        FROM `{input_table}`
        WHERE role IS NOT NULL AND role IN ('owner', 'agent')
    )
    GROUP BY id
);

INSERT INTO `{output_table}` WITH TRUNCATE
SELECT * FROM $segment;

INSERT INTO `{sample_table}` WITH TRUNCATE
SELECT matching.target_id AS yandexuid
FROM `{puid_yandexuid}` AS matching
LEFT SEMI JOIN $segment AS segment
USING(id);
"""


class SpravochnikUsers(RegularSegmentBuilder):
    keyword = 557
    name_segment_dict = {
        'spravochnik_users': 11552104,
    }

    def requires(self):
        return ExternalInput(config.SPRAV_COMPANY_TO_OWNER)

    def build_segment(self, inputs, output_path):
        with self.yt.TempTable() as sample_table:
            self.yql.query(
                yql_query_template.format(
                    input_table=self.input().table,
                    output_table=output_path,
                    sample_table=sample_table,
                    puid_yandexuid=get_matching_table('puid', 'yandexuid', indevice=True),
                ),
                transaction=self.transaction,
            )

            self.prepare_samples_for_lal(
                input_table=sample_table,
                id_field='yandexuid',
                lals_params=[LaLParams(
                    name='spravochnik_users',
                    id=17727073,
                    type='audience_segments',
                    coverage=3000000,
                    include_input=False,
                )],
            )
