#!/usr/bin/env python
# -*- coding: utf-8 -*-
from crypta.profile.utils.luigi_utils import ExternalInput
from crypta.profile.utils.segment_utils.builders import (
    LaLParams,
    RegularSegmentBuilder,
)
from crypta.profile.utils.utils import get_matching_table

USLUGI_PUID_TO_WORKER = '//home/ydo/backups/prod/current/puid_to_worker_id'


yql_query_template = u"""
$segment = (
    SELECT
        id,
        'puid' AS id_type,
        'org_accounts_owners' AS segment_name
    FROM (
        SELECT puid AS id
        FROM `{input_table}`
        WHERE org_permalink IS NOT NULL OR chain_permalink IS NOT NULL
    )
    GROUP BY id
);

INSERT INTO `{output_table}` WITH TRUNCATE
SELECT * FROM $segment;

INSERT INTO `{sample_table}` WITH TRUNCATE
SELECT
    matching.target_id AS yandexuid,
    'org_accounts_owners' As segment_name
FROM `{puid_yandexuid}` AS matching
LEFT SEMI JOIN $segment AS segment
USING(id);
"""


class UslugiOrganizationsOwners(RegularSegmentBuilder):
    keyword = 557
    name_segment_dict = {
        'org_accounts_owners': 17727820,
    }

    def requires(self):
        return ExternalInput(USLUGI_PUID_TO_WORKER)

    def build_segment(self, inputs, output_path):
        with self.yt.TempTable() as sample_table:
            self.yql.query(
                yql_query_template.format(
                    input_table=self.input().table,
                    output_table=output_path,
                    sample_table=sample_table,
                    puid_yandexuid=get_matching_table('puid', 'yandexuid', indevice=True),
                ),
                transaction=self.transaction,
            )

            self.prepare_samples_for_lal(
                input_table=sample_table,
                id_field='yandexuid',
                lals_params=[LaLParams(
                    name='org_accounts_owners',
                    id=17865109,
                    type='audience_segments',
                    coverage=3000000,
                    include_input=False,
                )],
            )
