#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os

from crypta.profile.utils.luigi_utils import ExternalInputDate
from crypta.profile.utils.segment_utils.builders import RegularSegmentBuilder


WEATHER_UNSUBSCRIBERS = '//home/sup/datasync_loader'

yql_query_template = u"""
INSERT INTO `{output_table}` WITH TRUNCATE
SELECT DISTINCT
    `uuid` AS id,
    'uuid' AS id_type,
    'unsubscribed' AS segment_name
FROM RANGE(`{input_dir}`)
WHERE success == True AND updated == True;
"""


class WeatherPushesUnsubscribers(RegularSegmentBuilder):
    keyword = 549
    name_segment_dict = {
        'unsubscribed': 2117,
    }
    indevice = True

    def requires(self):
        return ExternalInputDate(os.path.join(WEATHER_UNSUBSCRIBERS, self.yt.list(WEATHER_UNSUBSCRIBERS)[-1]), self.date)

    def build_segment(self, inputs, output_path):
        self.yql.query(
            yql_query_template.format(
                input_dir=WEATHER_UNSUBSCRIBERS,
                output_table=output_path,
            ),
            transaction=self.transaction,
        )
