#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os

from crypta.profile.utils.config import config
from crypta.profile.utils.luigi_utils import AttributeExternalInput
from crypta.profile.utils.segment_utils.builders import RegularSegmentBuilder
from crypta.profile.utils.segment_utils.processors import DayProcessor, LogProcessor


day_processor_query = """
INSERT INTO `{output_table}` WITH TRUNCATE
SELECT DISTINCT yandexuid
FROM `{input_table}`
"""


class ProcessedBarForYandexBrowserUsers(DayProcessor):
    def requires(self):
        return AttributeExternalInput(
            os.path.join(
                config.BAR_PARSED_DIR,
                self.date,
            ),
            attribute_name='closed',
            attribute_value=True,
        )

    def process_day(self, inputs, output_path):
        self.yql.query(
            day_processor_query.format(
                input_table=inputs.table,
                output_table=output_path,
            ),
            transaction=self.transaction,
        )


aggregetion_query = """
INSERT INTO `{output_table}` WITH TRUNCATE
SELECT DISTINCT
    CAST(yandexuid AS String) AS id,
    'yandexuid' AS id_type,
    'yandex_browser_users' AS segment_name
FROM `{bar_table}`
"""


class YandexBrowserUsers(RegularSegmentBuilder):
    name_segment_dict = {
        'yandex_browser_users': (549, 2179),
    }
    number_of_days = 35
    indevice = True

    def requires(self):
        return {
            'bar': LogProcessor(
                ProcessedBarForYandexBrowserUsers,
                self.date,
                self.number_of_days,
            ),
        }

    def build_segment(self, inputs, output_path):
        self.yql.query(
            aggregetion_query.format(
                bar_table=inputs['bar'].table,
                output_table=output_path,
            ),
            transaction=self.transaction,
        )
