#!/usr/bin/env python
# -*- coding: utf-8 -*-

from crypta.profile.utils.config import config
from crypta.profile.utils.luigi_utils import ExternalInput
from crypta.profile.utils.segment_utils.builders import RegularSegmentBuilder


get_kp_ids_yandexuids_query_template = """
INSERT INTO `{output_table}` WITH TRUNCATE
SELECT
    kinopoisk_yandexuids.id1 AS id,
    'yandexuid' AS id_type,
    'kp_id_with_passport_id' AS segment_name
FROM `{kp_users_table}` AS kinopoisk_users
INNER JOIN `{kp_id_yandexuid_direct_matching}` AS kinopoisk_yandexuids
ON CAST(kinopoisk_users.user_id AS String) == kinopoisk_yandexuids.id2
WHERE kinopoisk_users.yandex_user_id IS NOT NULL
"""


class KinopoiskLogins(RegularSegmentBuilder):
    keyword = 557
    indevice = True
    name_segment_dict = {
        'kp_id_with_passport_id': 4791001,
    }

    def requires(self):
        return {
            'kinopoisk_users': ExternalInput('//home/kinopoisk/crm/production/users'),
            'kinopoisk_id_to_yandexuid': ExternalInput(config.KINOPOISK_ID_TO_YANDEXUID),
        }

    def build_segment(self, inputs, output_path):
        self.yql.query(
            query_string=get_kp_ids_yandexuids_query_template.format(
                kp_users_table=inputs['kinopoisk_users'].table,
                kp_id_yandexuid_direct_matching=inputs['kinopoisk_id_to_yandexuid'].table,
                output_table=output_path,
            ),
            transaction=self.transaction,
        )
