#!/usr/bin/env python
# -*- coding: utf-8 -*-
from crypta.profile.utils.luigi_utils import ExternalInput
from crypta.profile.utils.segment_utils.builders import RegularSegmentBuilder


query_template = '''
$content_type_names = ('ott-episode', 'ott-movie');
$monetization_models = ('SVOD', 'TVOD', 'EST');

$kp_users = (
    SELECT
        yandexuid, monetization_model
    FROM `{input_table}`
    WHERE content_type_name in $content_type_names
    AND content_start = '1'
    GROUP BY (yandexuid, monetization_model)
);

$kp_users_all = (
    SELECT DISTINCT yandexuid
    FROM $kp_users
);

$kp_users_hd = (
    SELECT DISTINCT yandexuid
    FROM $kp_users
    WHERE monetization_model IN $monetization_models
);

INSERT INTO `{output_table}` WITH TRUNCATE

SELECT
    yandexuid AS id,
    'yandexuid' AS id_type,
    'kinopoisk_paid_content_consumers' AS segment_name
FROM $kp_users_hd

UNION ALL

SELECT
    yandexuid AS id,
    'yandexuid' as id_type,
    'kinopoisk_all_types_content_consumers' AS segment_name
FROM $kp_users_all;
'''


class KinopoiskMovieWatchers(RegularSegmentBuilder):
    keyword = 557
    name_segment_dict = {
        'kinopoisk_paid_content_consumers': 17787907,
        'kinopoisk_all_types_content_consumers': 17787901
    }

    def requires(self):
        return ExternalInput('//home/ott/tracking/all_sessions')

    def build_segment(self, inputs, output_path):
        self.yql.query(
            query_template.format(input_table=inputs.table, output_table=output_path)
        )
