#!/usr/bin/env python
# -*- coding: utf-8 -*-

from crypta.profile.utils.segment_utils.builders import RegularSegmentBuilder
from crypta.profile.utils.luigi_utils import ExternalInput
from crypta.profile.utils.config.config import GEO_CRYPTA_ID

yql_query_template = u"""
INSERT INTO `{output_table}` WITH TRUNCATE
SELECT
    crypta_id as id,
    'crypta_id' as id_type,
    'kz_users' as segment_name
FROM `{input_table}`
WHERE main_region_country == 159
"""


class KzUsers(RegularSegmentBuilder):
    keyword = 547
    name_segment_dict = {
        'kz_users': 1846,
    }

    def requires(self):
        return ExternalInput(GEO_CRYPTA_ID)

    def build_segment(self, inputs, output_path):
        self.yql.query(
            yql_query_template.format(
                input_table=inputs.table,
                output_table=output_path,
            ),
            transaction=self.transaction,
        )
