#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os

from crypta.profile.utils.config import config
from crypta.profile.utils.luigi_utils import ExternalInput
from crypta.profile.utils.segment_utils.builders import RegularSegmentBuilder
from crypta.profile.utils.segment_utils.processors import DayProcessor, LogProcessor


laptop_users_query = """
INSERT INTO `{output_table}` WITH TRUNCATE
SELECT
    id,
    'yandexuid' AS id_type,
    'laptop_users' AS segment_name
FROM (
    SELECT uniqid AS id
    FROM `{input_table}`
    WHERE uniqid IS NOT NULL AND uniqid != '0' AND Metrika::ParseBrowserinfo(browserinfo)['dp'] == '0'
)
GROUP BY id
"""


filter_desktop_query = """
INSERT INTO `{output_table}` WITH TRUNCATE
SELECT
    segment.id AS id,
    segment.id_type AS id_type,
    segment.segment_name AS segment_name
FROM (
    SELECT id, id_type, segment_name
    FROM `{input_table}`
    GROUP BY id, id_type, segment_name
) AS segment
INNER JOIN `{yuid_with_all_info_table}` AS info
USING (id, id_type)
WHERE String::StartsWith(info.ua_profile, 'd|desk')
"""


class ProcessedWatchLogForLaptopUsers(DayProcessor):
    def requires(self):
        return ExternalInput(
            table=os.path.join(
                config.BS_WATCH_LOG_FOLDER,
                self.date,
            ),
        )

    def process_day(self, inputs, output_path):
        self.yql.query(
            laptop_users_query.format(
                input_table=inputs.table,
                output_table=output_path,
            ),
            transaction=self.transaction,
        )


class LaptopUsers(RegularSegmentBuilder):
    number_of_days = 30
    keyword = 549
    indevice = True
    name_segment_dict = {
        'laptop_users': 1152,
    }

    def requires(self):
        return {
            'ProcessedWatchLog': LogProcessor(
                ProcessedWatchLogForLaptopUsers,
                self.date,
                self.number_of_days,
            ),
        }

    def build_segment(self, inputs, output_path):
        self.yql.query(
            filter_desktop_query.format(
                input_table=inputs['ProcessedWatchLog'].table,
                output_table=output_path,
                yuid_with_all_info_table=config.YUID_WITH_ALL_INFO_TABLE,
            ),
            transaction=self.transaction,
        )
