#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os

from crypta.profile.utils.config import config
from crypta.profile.utils.segment_utils.builders import RegularSegmentBuilder
from crypta.profile.utils.segment_utils.processors import DayProcessor, LogProcessor
from crypta.profile.utils.luigi_utils import ExternalInput


query_template = """
INSERT INTO `{output_table}` WITH TRUNCATE
SELECT id, 'yandexuid' AS id_type, 'logged_in_for_plus' AS segment_name
FROM (
    SELECT uniqid AS id
    FROM `{input_table}`
    WHERE passportuid != '0' AND CAST(uniqid AS Uint64) IS NOT NULL AND uniqid != '0'
)
GROUP BY id
"""


class ProcessedMetricsForLoggedInForPlus(DayProcessor):
    def requires(self):
        return ExternalInput(os.path.join(config.BS_WATCH_LOG_FOLDER, self.date))

    def process_day(self, inputs, output_path):
        self.yql.query(
            query_template.format(
                input_table=inputs.table,
                output_table=output_path,
            ),
            transaction=self.transaction,
        )


class LoggedInForPlus(RegularSegmentBuilder):
    keyword = 557
    name_segment_dict = {
        'logged_in_for_plus': 6521188,
    }
    n_days = 3
    indevice = True

    def requires(self):
        return LogProcessor(
            ProcessedMetricsForLoggedInForPlus,
            self.date,
            self.n_days,
        )

    def build_segment(self, inputs, output_path):
        self.yt.unique(
            inputs.table,
            output_path,
            unique_by=['id', 'id_type', 'segment_name'],
        )
