#!/usr/bin/env python
# -*- coding: utf-8 -*-

from crypta.profile.utils.config import config
from crypta.profile.utils.luigi_utils import ExternalInput
from crypta.profile.utils.segment_utils.builders import RegularSegmentBuilder


query_template = """
INSERT INTO `{output_table}` WITH TRUNCATE
SELECT
    id,
    id_type,
    'macos_users' AS segment_name
FROM `{yandexuid_info_table}`
WHERE String::StartsWith(ua_profile, 'd|desk|macos')
"""


class MacOSUsers(RegularSegmentBuilder):
    keyword = 557
    indevice = True
    name_segment_dict = {
        'macos_users': 5468482,
    }

    def requires(self):
        return ExternalInput(config.YUID_WITH_ALL_INFO_TABLE)

    def build_segment(self, inputs, output_path):
        self.yql.query(
            query_string=query_template.format(
                yandexuid_info_table=inputs.table,
                output_table=output_path,
            ),
            transaction=self.transaction,
        )
