#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os

from crypta.profile.utils.config import config
from crypta.profile.utils.luigi_utils import ExternalInput
from crypta.profile.utils.segment_utils.builders import (
    LaLParams,
    RegularSegmentBuilder,
)


segment_query = """
INSERT INTO `{output_table}` WITH TRUNCATE
SELECT id, id_type, segment_name
FROM `{mail_data_table}`;

INSERT INTO `{sample_table}` WITH TRUNCATE
SELECT
    yandexuid,
    segment_name
FROM (
    SELECT matching.yandexuid AS yandexuid, mail_data.segment_name AS segment_name
    FROM `{mail_data_table}` AS mail_data
    INNER JOIN `{indevice_yandexuid_matching}` AS matching
    USING (id, id_type)
)
GROUP BY yandexuid, segment_name
"""


class PrepareMailSampleForLalSegments(RegularSegmentBuilder):
    keyword = 549
    name_segment_dict = {
        'aviaticket': 1404,
        'boardingpass': 1405,
        'hotel': 1406,
    }

    def requires(self):
        return ExternalInput(os.path.join(config.SEGMENT_EXTERNAL_DATA_FOLDER, 'mail_data'))

    def build_segment(self, inputs, output_path):
        with self.yt.TempTable() as sample_table:
            self.yql.query(
                segment_query.format(
                    mail_data_table=inputs.table,
                    indevice_yandexuid_matching=config.INDEVICE_YANDEXUID,
                    output_table=output_path,
                    sample_table=sample_table,
                ),
                transaction=self.transaction,
            )

            segment_name_to_id_dict = {
                'aviaticket': 1407,
                'boardingpass': 1409,
                'hotel': 1408,
            }

            lals_params = list()
            for segment_name, segment_id in segment_name_to_id_dict.iteritems():
                lals_params.append(LaLParams(
                    name=segment_name,
                    id=segment_id,
                    type='lal_internal',
                    coverage=5e6,
                    include_input=False,
                ))

            self.prepare_samples_for_lal(
                input_table=sample_table,
                id_field='yandexuid',
                lals_params=lals_params,
            )
