#!/usr/bin/env python
# -*- coding: utf-8 -*-

from crypta.profile.utils.config import config
from crypta.profile.utils.luigi_utils import ExternalInput
from crypta.profile.utils.segment_utils.builders import RegularSegmentBuilder


segment_query = """
INSERT INTO `{output_table}`
WITH TRUNCATE
SELECT
    id,
    id_type,
    CASE
        WHEN model ILIKE '%honor%' THEN 'honor'
        ELSE 'huawei'
    END AS segment_name
FROM `{input_table}`
WHERE manufacturer IS NOT NULL AND model IS NOT NULL AND device_type == 'phone' AND manufacturer == 'Huawei'
"""


class ManufacturerPhoneOwners(RegularSegmentBuilder):
    name_segment_dict = {
        'honor': (557, 16977400),
        'huawei': (557, 16977394),
    }

    def requires(self):
        return ExternalInput(config.APP_METRICA_MONTH)

    def build_segment(self, inputs, output_path):
        self.yql.query(
            query_string=segment_query.format(
                input_table=inputs.table,
                output_table=output_path,
            ),
            transaction=self.transaction,
        )
