#!/usr/bin/env python
# -*- coding: utf-8 -*-

import luigi

from crypta.profile.utils.config import config
from crypta.profile.utils.luigi_utils import (
    BaseYtTask,
    ExternalInputDate,
    YtDailyRewritableTarget,
)

from crypta.lib.python.custom_ml.tools.features import MakeCatboostFeatures
from crypta.lib.python.custom_ml.training_config import segment_feature_types


class PrepareCatboostFeatures(BaseYtTask):
    date = luigi.Parameter()
    juggler_host = config.CRYPTA_ML_JUGGLER_HOST
    task_group = 'coded_segments'

    def __init__(self, date):
        super(PrepareCatboostFeatures, self).__init__(date)

    def requires(self):
        return ExternalInputDate(
            table=config.USER_DATA_TABLE,
            date=self.date,
            field='_last_update_date',
        )

    def output(self):
        return YtDailyRewritableTarget(
            table=config.CATBOOST_FEATURES_TABLE,
            date=self.date,
            allow_great_or_equal_date=True,
        )

    def run(self):
        with self.yt.Transaction():
            self.yt.create_empty_table(
                self.output().table,
                schema={
                    'PassThrough': 'string',
                    'FloatFeatures': 'any',
                    'CatFeatures': 'any',
                },
            )

            self.yt.run_map(
                MakeCatboostFeatures(
                    yt=self.yt,
                    segment_feature_types=segment_feature_types,
                    vector_size=config.VECTOR_SIZE,
                    training_mode=False,
                ),
                self.yt.TablePath(
                    self.input().table,
                    columns=('yuid', 'Vectors', 'Attributes', 'Segments'),
                ),
                self.output().table,
            )

            self.yt.set_attribute(self.output().table, 'generate_date', self.date)
