#!/usr/bin/env python
# -*- coding: utf-8 -*-

from yt.wrapper import aggregator

from crypta.profile.utils.utils import get_matching_table
from crypta.profile.utils.luigi_utils import ExternalInput
from crypta.profile.utils.segment_utils.builders import RegularSegmentBuilder

from crypta.profile.runners.segments.lib.coded_segments.data.mobile_operators_codes import operators_codes


@aggregator
class Mapper(object):
    def __init__(self, operators_codes):
        self.operators_codes = operators_codes

    def __call__(self, rows):
        for row in rows:
            if len(row['target_id']) == 12 and row['target_id'][:2] == '+7':
                code = int(row['target_id'][2:5])
                number = int(row['target_id'][5:])
                for name in self.operators_codes:
                    if code in self.operators_codes[name]:
                        for pair in self.operators_codes[name][code]:
                            if pair[0] <= number <= pair[1]:
                                if name in {'MTS', 'Tele2', 'Beeline', 'Megafon'}:
                                    yield {
                                        'id': row['target_id'],
                                        'id_type': 'phone',
                                        'segment_name': name,
                                    }
                                else:
                                    yield {
                                        'id': row['target_id'],
                                        'id_type': 'phone',
                                        'segment_name': 'Virtual',
                                    }


class MobileOperatorsUsersByPrefix(RegularSegmentBuilder):
    name_segment_dict = {
        'Megafon': 1293,
        'MTS': 1292,
        'Beeline': 1291,
        'Tele2': 1290,
        'Virtual': 1296
    }

    keyword = 547

    def requires(self):
        return ExternalInput(get_matching_table('crypta_id', 'phone'))

    def build_segment(self, inputs, output_path):
        self.yt.run_map(
            Mapper(operators_codes),
            inputs.table,
            output_path,
        )
