#!/usr/bin/env python
# -*- coding: utf-8 -*-

from crypta.profile.utils.config import config
from crypta.profile.utils.luigi_utils import ExternalInput
from crypta.profile.utils.segment_utils.builders import RegularSegmentBuilder


multidevice_query_template = """
INSERT INTO `{output_table}` WITH TRUNCATE
SELECT
    crypta_id AS id,
    'crypta_id' AS id_type,
    'multidevice' AS segment_name
FROM (
    SELECT
        matching.cryptaId AS crypta_id,
        COUNT(app.id) AS n_devices,
        COUNT_IF(DictKeys(app.simcards_operators) == AsList((250, 99))) AS beeline_only
    FROM `{app_metrica_month}` AS app
    INNER JOIN `{matching}` AS matching
    USING (id, id_type)
    WHERE ListLength(app.simcards_operators) != 0
    GROUP BY matching.cryptaId
    HAVING(COUNT(app.id) > 1)
)
WHERE n_devices - beeline_only > 0
"""


class Multidevice(RegularSegmentBuilder):
    name_segment_dict = {
        'multidevice': 18456727,
    }
    keyword = 557

    def requires(self):
        return {
            'app_metrica_month': ExternalInput(config.APP_METRICA_MONTH),
            'matching':  ExternalInput(config.VERTICES_NO_MULTI_PROFILE),
        }

    def build_segment(self, inputs, output_path):
        self.yql.query(
            query_string=multidevice_query_template.format(
                app_metrica_month=inputs['app_metrica_month'].table,
                matching=inputs['matching'].table,
                output_table=output_path,
            ),
            transaction=self.transaction,
        )
