#!/usr/bin/env python
# -*- coding: utf-8 -*-

from crypta.profile.utils.config import config
from crypta.profile.utils.luigi_utils import ExternalInput
from crypta.profile.utils.segment_utils.builders import RegularSegmentBuilder


def region_mapper(row):
    nespresso_cities = {213, 2, 39, 54, 65, 35, 47, 56, 51, 62, 193, 172}
    starbucks_cities = {54, 65, 35, 47, 56, 51, 62, 193, 172, 39, 43, 66, 38, 15, 50}

    if not row['main_region_city']:
        return

    if row['main_region_city'] in nespresso_cities:
        yield {
            'id': row['id'],
            'id_type': 'yandexuid',
            'segment_name': 'nespresso'
        }

    if row['main_region_city'] in starbucks_cities:
        yield {
            'id': row['id'],
            'id_type': 'yandexuid',
            'segment_name': 'starbucks'
        }


class NestleRegions(RegularSegmentBuilder):
    name_segment_dict = {
        'nespresso': 17439664,
        'starbucks': 17439661,
    }

    keyword = 557

    def requires(self):
        return ExternalInput(config.YUID_WITH_ALL_INFO_TABLE)

    def build_segment(self, inputs, output_path):
        self.yt.run_map(
            region_mapper,
            inputs.table,
            output_path,
        )
