#!/usr/bin/env python
# -*- coding: utf-8 -*-

from crypta.profile.utils.config import config
from crypta.profile.utils.luigi_utils import ExternalInput
from crypta.profile.utils.segment_utils.builders import RegularSegmentBuilder

yql_query = """
INSERT INTO `{output_table}` WITH TRUNCATE
SELECT
    id,
    id_type,
    'esim' AS segment_name
FROM `{input_table}`
WHERE
    manufacturer LIKE 'Apple%'
    AND (model LIKE '%Phone X_%' OR model LIKE '%Phone11%' OR model LIKE '%Phone12%'
        OR ListHas(AsList('iPad Air 3', 'iPad Pro (12.9\")', 'iPad mini 5'), model))
    AND CAST(SUBSTRING(os_version, 0, 4) as Float) >= 12.1
    OR
    manufacturer LIKE 'Google%'
    AND (model LIKE 'Pixel%3%' OR model LIKE 'Pixel%4%')
    AND CAST(SUBSTRING(os_version, 0, 2) as Float) >= 10
    OR
    manufacturer LIKE 'Samsung%' AND model LIKE 'Galaxy S20%'
    OR
    manufacturer LIKE 'Huawei%' AND model LIKE 'P40%';
"""


class PhoneWithEsimOwners(RegularSegmentBuilder):
    name_segment_dict = {
        'esim': 15617296,
    }
    keyword = 557

    def requires(self):
        return ExternalInput(config.APP_METRICA_MONTH)

    def build_segment(self, inputs, output_path):
        self.yql.query(
            yql_query.format(
                input_table=inputs.table,
                output_table=output_path,
            ),
            transaction=self.transaction,
        )
