#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os

from crypta.profile.lib import date_helpers

from crypta.profile.utils.config import config
from crypta.profile.utils.segment_utils.builders import RegularSegmentBuilder
from crypta.profile.utils.luigi_utils import ExternalInput


potential_aon_users_query_template = """
$aon_pp_android_history = (
SELECT
    device_id,
    ListMap(cid_history, ($x)->{{return $x.current}}) AS all_states,
    ListLast(cid_history).current AS state_now,
    ListLast(cid_history).app_version AS app_version,
FROM `{setting_history}`
WHERE cid_history IS NOT NULL AND device_id IS NOT NULL
);

INSERT INTO `{output_table}` WITH TRUNCATE
SELECT
    device_id AS id,
    'mm_device_id' AS id_type,
    'potential_aon_users' AS segment_name,
FROM $aon_pp_android_history
WHERE
    state_now == 'false'
    AND NOT ListHas(all_states, 'true')
    AND app_version >= '7.30';
"""


class PotentialAonUsers(RegularSegmentBuilder):
    keyword = 549
    name_segment_dict = {
        'potential_aon_users': 1319,
    }

    indevice = True

    def requires(self):
        return ExternalInput(os.path.join(config.PP_ANDROID_SETTINGS, date_helpers.get_yesterday(self.date)))

    def build_segment(self, inputs, output_path):
        self.yql.query(
            potential_aon_users_query_template.format(
                setting_history=inputs.table,
                output_table=output_path,
            ),
            transaction=self.transaction,
        )
