#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os

from crypta.profile.lib import date_helpers

from crypta.profile.utils.config import config
from crypta.profile.utils.luigi_utils import ExternalInput
from crypta.profile.utils.segment_utils.builders import RegularSegmentBuilder


potential_ios_whocalls_users_query = """
$pp_enable_history = (
    SELECT
        device_id,
        enable_history,
        ListMap(enable_history, ($x)->{{return $x.current}}) as all_states,
        ListLast(enable_history).current as state_now,
        ListLast(enable_history).os_version as os_version,
        ListLast(enable_history).app_version as app_version,
        ListHead(enable_history).event_datetime as event_datetime
    FROM `{pp_ios_settings}`
    WHERE enable_history is not NULL AND device_id is not NULL
);

$bro_enable_history = (
SELECT
    device_id,
    ListMap(enable_history, ($x)->{{return $x.current}}) as all_states,
    ListLast(enable_history).current as state_now,
    ListLast(enable_history).os_version as os_version,
    ListLast(enable_history).app_version as app_version,
    ListHead(enable_history).event_datetime as event_datetime
FROM `{bro_ios_settings}`
WHERE enable_history is not NULL AND device_id is not NULL
);

$pp_whocalls_avaliable = (
    SELECT
        device_id as id,
        'idfa' as id_type,
        'pp_ios' as segment_name,
        event_datetime
    FROM $pp_enable_history
    WHERE
        state_now == 'disabled' AND NOT
        ListHas(all_states, 'enabled') AND
        os_version >= '11' AND
        app_version >= '4060000'
);

$pp_whocalls_avaliable_alice = (
    SELECT
        device_id as id,
        'idfa' as id_type,
        'pp_ios_alice' as segment_name
    FROM $pp_enable_history
    WHERE
        state_now == 'disabled' AND NOT
        ListHas(all_states, 'enabled') AND
        os_version >= '11' AND
        app_version >= '4090000'
);

$bro_whocalls_avaliable = (
    SELECT
        device_id as id,
        'idfa' as id_type,
        'bro_ios' as segment_name,
        event_datetime
    FROM $bro_enable_history
    WHERE
        state_now == 'disabled' AND NOT
        ListHas(all_states, 'enabled') AND
        os_version >= '11' AND
        app_version >= '20.4.3'
);

INSERT INTO `{output_table}` WITH TRUNCATE
SELECT *
FROM (
    SELECT
        id,
        id_type,
        'new_ios' as segment_name
    FROM (
        SELECT * FROM $pp_whocalls_avaliable
        UNION ALL
        SELECT * FROM $bro_whocalls_avaliable
    )
    WHERE event_datetime >= '{date_begin}'

    UNION ALL

    SELECT
        id,
        id_type,
        segment_name
    FROM $pp_whocalls_avaliable

    UNION ALL

    SELECT
        id,
        id_type,
        segment_name
    FROM $pp_whocalls_avaliable_alice

    UNION ALL

    SELECT
        id,
        id_type,
        segment_name
    FROM $bro_whocalls_avaliable
)
GROUP BY id, id_type, segment_name;
"""


class PotentialAonIosUsers(RegularSegmentBuilder):
    name_segment_dict = {
        'bro_ios': (549, 1813),
        'new_ios': (549, 1814),
        'pp_ios': (549, 2074),
        'pp_ios_alice': (549, 2075),
    }

    indevice = True

    def requires(self):
        return {
            'BroIosSettings': ExternalInput(os.path.join(config.BRO_IOS_SETTINGS, self.date)),
            'PpIosSetting': ExternalInput(os.path.join(config.PP_IOS_SETTINGS, self.date)),
        }

    def build_segment(self, inputs, output_path):
        self.yql.query(
            potential_ios_whocalls_users_query.format(
                pp_ios_settings=inputs['PpIosSetting'].table,
                bro_ios_settings=inputs['PpIosSetting'].table,
                date_begin=date_helpers.get_date_from_past(self.date, 15),
                output_table=output_path,
            ),
            transaction=self.transaction,
        )
