#!/usr/bin/env python
# -*- coding: utf-8 -*-

from crypta.profile.utils.config import config
from crypta.profile.utils.segment_utils.builders import RegularSegmentBuilder
from crypta.profile.utils.luigi_utils import ExternalInput


yql_query_template = """
$preinstalled_searchapp = ToDict(AsList(
    ("highscreen", AsList("easy l", "easy l pro")),
    ("joyar", AsList("impress_frost")),
    ("oysters t104hvi 3g", AsList("oysters t104hvi 3g", "oysters t104hvi 3g", "oysters t104hvi 3g")),
    ("bqru", AsList("bqru-4526", "bqru-5022", "bqru-5037", "bqru-5525")),
    ("yandex", AsList("yndx-000sb")),
    ("jinga", AsList("touch4g")),
    ("sony", AsList("h9436", "h4413")),
    ("dexp", AsList("dexp ixion e 5", "dexp ixion es 4", "dexp ixion es2 4.5", "dexp ixion ml2 5", "dexp ixion x 4.5", "dexp ixion x 5", "ixion el150 charger", "ixion x250 octava",
                    "ixion xl145 snatch", "ixion m155", "ixion x155", "ixion es155", "ixion es245", "ixion m350", "ixion xl140", "ixion xl240", "ixion e145", "ixion m245", "ixion p145 dominator",
                    "ixion el350", "ixion ml150", "ixion ms350", "ixion x355", "ixion p135", "ixion p150", "ixion e150", "ixion e250", "ixion es260", "ixion es450", "ixion es650", "ixion m450",
                    "ixion ms250", "ixion ms450", "ixion x245", "ixion_es255", "dexp ursus 10e 3g", "dexp ursus 10m 3g", "ursus 10m2 3g", "dexp ursus 10ev 3g", "dexp ursus 7e", "dexp ursus 7e 3g",
                    "dexp ursus 7m2 3g", "dexp ursus 7mv", "dexp ursus 7mv2 3g", "dexp ursus 7mv3 3g", "dexp ursus 7mv4 3g", "dexp ursus 7p", "ursus 8e mini", "dexp ursus 8ev", "ursus 8ev2 3g",
                    "dexp ursus 8x 4g", "ursus 9ev mini 3g", "ursus 9px 3g", "ursus_9x3g", "dexp ursus 10ev", "ursus a170i", "ursus ns110", "dexp al-2020", "dexp al-3020", "ursus g170 hit",
                    "ursus ts170", "ursus ts197 navis", "ld300", "ld303", "ld305", "ursus a170 hit", "ursus g270i", "ursus ns180", "ursus a210", "ursus a370i", "ursus a470", "ursus ts270",
                    "ursus gx180", "ursus ns170i", "ursus ns210", "ursus ns270", "ursus ns310", "ursus ns370", "ursus z280", "ursus z380", "ursus a169", "ursus a169i", "ursus a269", "ursus ts370",
                    "al-1000", "ursus a210i", "ursus kx270", "ursus kx370", "ursus ns280", "ursus ns470", "ursus ts210", "ixion xl145 snatch", "dexp ursus 10e 3g")),
    ("t84p 3g", AsList("oysters t84p 3g", "oysters t84p 3g")),
    ("vivo", AsList("vivo 1804", "vivo 1806", "vivo 1724", "vivo 1807", "vivo 1815", "vivo 1816")),
    ("zte", AsList("a601", "z10", "mflogin4", "blade v7 plus")),
    ("unknown", AsList("oysters t72x 3g", "oysters t72x 3g")),
    ("oysters t104hmi 3g", AsList("oysters t104hmi 3g", "oysters t104hmi 3g", "oysters t104hmi 3g")),
    ("stark", AsList("impress strong")),
    ("huawei", AsList("bkl-l09", "chm-u01", "che2-l11", "g610-u20", "huawei honor pro", "y635-l21", "y6", "h60-l04", "g700-u10", "honor3", "g630-u10", "g620s-l01", "huawei honor 2", "y541-u02",
                      "g730-u10", "huawei ascend g500 pro", "y330-u11", "y530", "y300", "g6-u10", "huawei ascend p1", "y550-l01", "ascend d", "huawei honor", "huawei ascend g300",
                      "huawei ascend g330", "g750-u10", "y511-u30", "p6s-u06", "huawei ascend p1 xl", "huawei ascend y201 pro", "huawei ascend d1", "huawei p2-6011", "g510", "g6-l11", "y336-u02",
                      "y625-u32", "y600", "liszt", "hol-u19", "pe-tl10", "mt7-tl10", "bah-l09", "kob-l09", "bg2-w09", "cun-u29", "cun-l21", "eml-l29", "rne-l21", "bnd-l21", "jmm-l22", "ane-lx1",
                      "lld-l31", "col-l29", "hma-l29", "lya-l29", "aum-l41", "dua-l22", "atu-l31", "aum-l29", "clt-l29", "par-lx1", "jsn-l21", "fig-lx1", "bkk-l21", "dra-lx5", "pct-l29", "vog-l29",
                      "ele-l29", "mar-lx1m")),
    ("media pad", AsList("oysters t82p 3g", "oysters t82p 3g", "oysters t82p 3g")),
    ("oysters t72mr 3g", AsList("oysters t72mr 3g", "oysters t72mr 3g")),
    ("prestigio", AsList("pmt3608_4g", "pmt3137_3g", "pmt3797_3g", "pmt3777_3g", "pmt3777_3ge", "pmt3767_3g", "pmt3118_3ge", "pmt3318_3ge", "pmt3418_4g", "pmt3418_4ge", "pmt3518_4g", "pmt3518_4ge",
                         "pmt3618_4g", "psp3468duo", "psp3537duo", "psp3528duo", "psp3527duo", "psp7501duo", "psp3511duo", "psp5506duo", "psp3533duo", "psp5530duo", "psp7551duo", "psp3517duo",
                         "psp5509duo", "psp3508duo", "psp3458duo", "psp3507duo", "psp3506duo", "psp3516duo", "psp5502duo", "psp3510duo", "psp3471duo", "psp3470duo", "psp3423duo", "psp7570duo",
                         "psp7550duo", "psp7512duo", "psp7511duo", "psp7510duo", "psp5552duo", "psp5520duo", "psp5518duo", "psp5515duo", "psp5511duo", "psp5510duo", "psp3552duo", "pmt3708_3g",
                         "pmt3637_4g", "pmt3537_4g", "pmt3437_4g", "pmt3427_3g", "pmt3327_3g", "pmt3317_3g", "pmt3171_3g", "pmt3161_3g", "pmt3157_4g", "pmt3157_3g", "pmt3151_3g", "pmt3101_4g",
                         "psp3406duo", "psp3495duo", "psp5522duo", "psp5545duo", "psp7530duo", "pmt3618_4ge", "pmt1177_4g", "pmt5718_4g", "pmt3608_4g", "pmt3137_3g", "pmt3797_3g", "pmt3777_3g",
                         "pmt3777_3ge", "pmt3767_3g", "psp3468duo", "psp3537duo", "psp3528duo", "psp3527duo", "psp7501duo", "psp3533duo", "psp5530duo", "pmt3118_3ge", "pmt3318_3ge", "pmt3418_4g",
                         "pmt3418_4ge", "pmt3518_4g", "pmt3518_4ge", "pmt3618_4g", "psp7551duo", "psp3511duo", "psp5506duo", "psp3517duo", "psp5509duo", "psp3508duo", "psp3458duo", "psp3507duo",
                         "psp3506duo", "psp5502duo", "psp3510duo", "psp3471duo", "psp3470duo", "psp3423duo", "psp7570duo", "psp7550duo", "psp7512duo", "psp7511duo", "psp7510duo", "psp5552duo",
                         "psp5520duo", "psp5518duo", "psp5515duo", "psp5511duo", "psp5510duo", "psp3552duo", "psp3406duo", "psp3495duo", "psp5522duo", "psp5545duo", "psp3516duo", "pmt3708_3g",
                         "pmt3637_4g", "pmt3537_4g", "pmt3437_4g", "pmt3427_3g", "pmt3327_3g", "pmt3317_3g", "pmt3171_3g", "pmt3161_3g", "pmt3157_4g", "pmt3157_3g", "pmt3151_3g", "pmt3101_4g")),
    ("vexmobile", AsList("impress_fire", "impress_cube")),
    ("fly", AsList("fs509", "iq4411", "fs525", "fs529", "fs528", "fs527", "fs526", "fs530", "mega", "photo pro", "slimline", "view", "life jet", "power plus 5000", "life sky", "life ace",
                   "life compact 4g", "life jet")),
    ("philips", AsList("philips s318", "philips x818")),
    ("vertex", AsList("impress_glory", "impress eno", "impress_intouch_4g", "impress more", "impress x", "impress action", "impress hero", "impress fortune", "impress lotus", "impress_razor",
                      "impress razor", "impress tor", "impress_wolf", "impress_pear", "impress_spring", "impress_energy", "impress_vega", "impress_forest", "impress_aqua", "impress_disco",
                      "impress_phonic", "impress_blade", "impress_new", "lion_dual", "impress_wolf", "impress_pear", "impress_vega", "impress_frost", "impress_spring")),
    ("oysters t72x 3g", AsList("oysters t72x 3g", "oysters t72x 3g")),
    ("wileyfox", AsList("swift", "swift 2", "storm")),
    ("hmd global", AsList("nokia 1", "nokia 2.1")),
    ("pacific800i", AsList("pacific800i")),
    ("bq", AsList("bq1008g", "bqs-4570", "bq-6050", "bqs-5065", "bq-4026", "bq-5032", "bq-5033", "bq-5052", "bq-5071", "bq-5082", "bqs_5505", "bqs-4800", "bqs-5020", "bqs-5025", "bqs-5030",
                  "bqs-5040", "bqs-5045", "bqs-5050", "bqs-5515", "bq-6050", "bqs-5065")),
    ("sp56", AsList("sp56")),
    ("spreadtrum", AsList("sp41", "sp 35")),
    ("alps", AsList("oysters t84mri 3g", "oysters t72h 3g", "oysters t84hvi 3g", "oysters t84hri 3g", "oysters t7v 3g", "oysters t72hs 3g", "oysters t72hsi 3g", "oysters t72hmi 3g", "oysters t7x 3g",
                    "oysters t72m 3g", "oysters t784hri 3g", "t7v 3g", "sp42", "sp50", "oysters t84hvi 3g", "oysters t72hsi 3g", "oysters t72hs 3g", "oysters t7x 3g", "oysters t72h 3g",
                    "oysters t84mri 3g", "oysters t72h 3g", "oysters t84hvi 3g", "oysters t84hri 3g", "oysters t7v 3g", "oysters t72hs 3g", "oysters t72hsi 3g", "oysters t72hmi 3g", "oysters t7x 3g",
                    "oysters t72m 3g", "oysters t784hri 3g")),
    ("lenovo", AsList("lenovo p70", "ideatab s6000", "b8000-h", "b6000-h", "ideatab a3000", "lenovotab2 a7-30dc", "s5000", "lenovo a7000", "b8000-f", "b6000-f", "s6000l")),
    ("bqs-4525", AsList("bqs-4525")),
    ("micromax", AsList("micromax q415", "micromax q351", "micromax q397", "q415", "micromax q402+", "micromax q440", "micromax q437", "micromax bharat 5", "micromax q454", "micromax q415",
                        "micromax q351", "micromax q397")),
    ("samsung", AsList("sm-j260f")),
    ("oysters t72hri 3g", AsList("oysters t72hri 3g", "oysters t72hri 3g", "oysters t72hri 3g")),
    ("irbis", AsList("tx01", "tx21", "tx22", "tx24", "tx25", "tx26", "tx95", "tx11", "tx12", "tx29", "tx51", "tx52", "tx14", "tx58", "tx59", "tx76", "tx47", "tx49", "tz83", "tz84", "tz11", "tz12",
                     "tz16", "tz21", "tz22", "tz50", "tz51", "tz52", "tz53", "tz85", "tz86", "tz13", "tz14", "tz94", "tz43", "tz70", "tz82", "tz71", "tz10", "tz44", "tx89", "tx90", "tx19", "tx27",
                     "tx28", "tx35", "tz45", "tz72", "tz46", "tz15", "tg74", "tg75", "tg79", "tg97", "tz03", "tz04", "tz05", "tz100", "tz101", "tz102", "tz104", "tz141", "tz142", "tz143", "tz144",
                     "tz161", "tz162", "tz171", "tz19", "tz191", "tz54", "tz55", "tz60", "tz62", "tz63l", "tz701", "tz702", "tz703", "tz707", "tz730", "tz731", "tz732", "tz735", "tz736", "tz737",
                     "tz738", "tz761", "tz765", "tz791", "tz80", "tz81l", "tz851", "tz852", "tz853", "tz861", "tz862", "tz863", "tz871", "tz881", "tz891", "tzart", "tzone", "tx60", "tx61", "tz197",
                     "tz897", "tz797", "sp05", "sp06", "sp20", "sp21", "sp43", "sp45", "sp46", "sp52", "sp57", "sp58", "sp59", "tz60")),
    ("oppo", AsList("cph1803", "cph1809", "cph1893", "cph1907")),
    ("nvidia", AsList("oysters t34", "oysters t37")),
    ("asus", AsList("asus_x013d", "asus_z01qd", "asus_x00qd", "asus_z01rd", "zs600kl", "zb602kl", "zb631kl", "zb633kl", "zs620kl")),
    ("oysters", AsList("atlantic454", "indian 254", "pacific454", "pacifice", "antarctice", "pacific4g", "pacifici4g", "pacificvs", "oysters_pacificv", "pacificv", "atlanticv", "arctic450",
                       "atlantic4g", "pacificxl4g", "indianv", "life4g", "t72 md", "oysters t74mri 3g", "t72 mr", "oysters t84m 3g", "oysters t72v 3g", "oysters t102mr 3g", "oysters t102ms 3g",
                       "t84mri 3g", "t74mri 3g", "t72ha 3g", "t104mbi 3g", "t102ms_3g", "t102mr 3g", "t72mr", "t72md", "t72ms", "t72mr 3g", "t84hvi 3g", "oysters t14n 3g", "oysters t80 3g",
                       "t82 3g", "t84hvi_3g", "t74er", "t84eri_3g", "t102er 3g", "t72er3g", "t102ms 3g", "t74mr4g", "t74ms", "t72ms3g", "t74mai 3g", "t84hai3g", "t104er4g", "t104mbi_3g", "t72ha_3g",
                       "t84ni_4g", "t84ni_3g", "t74n_3g", "t104b_3g", "t84ni 4g", "t84ni 3g", "t104b_4g", "t84bi_4g", "t74mai_3g", "t74rd", "t104sci_3g", "t74sc_3g", "t74d_3g", "t72n_3g", "t72er 3g",
                       "t102er3g", "oysters t7d 3g", "oysters t72 3g", "oysters t7b 3g", "t62i3g", "t72hm3g", "t74hmi_4g", "t72x 3g", "oysters t102ms 3g", "t84mri 3g", "t102mr 3g", "oysters t72v 3g",
                       "oysters t84m 3g", "oysters t74mri 3g", "t72mr 3g", "t104mbi 3g", "t72mr 3g", "t102mr 3g", "t72ha 3g", "t74mri 3g", "t72mr 3g", "t104mbi 3g", "t84hvi_3g", "t72mr 3g",
                       "t102mr 3g", "t72ha 3g", "t72 md", "oysters t74mri 3g", "t72 mr", "oysters t84m 3g", "oysters t72v 3g", "oysters t102mr 3g", "oysters t102ms 3g", "t84mri 3g", "t74mri 3g",
                       "t72ha 3g", "t104mbi 3g", "t102ms_3g", "t102mr 3g", "t72mr", "t72md", "t72ms", "t72x 3g", "t72mr 3g", "t84hvi 3g", "oysters t14n 3g", "oysters t80 3g", "t82 3g", "t84hvi_3g",
                       "t74er", "t84eri_3g", "t102er 3g", "t72er3g", "t102ms 3g", "t74mr4g", "t74ms", "t72ms3g", "t74mai 3g", "t84hai3g", "t104er4g", "oysters t72mr 3g")),
    ("4good", AsList("4good s450m 4g", "4good light a103")),
));


$preinstalled_bro = ToDict(AsList(
("highscreen", AsList("easy l", "easy l pro")),
("ark_electronic_technology", AsList("impulse p1")),
("joyar", AsList("start3g", "impress_frost")),
("oysters t104hvi 3g", AsList("oysters t104hvi 3g")),
("bqru", AsList("bqru-4526", "bqru-5022", "bqru-5037", "bqru-5525")),
("yandex", AsList("yndx-000sb")),
("jinga", AsList("l500", "jinga iron", "a500", "fresh4g", "storm", "a502", "picassonote", "touch4g")),
("sm503 ltd", AsList("sm503")),
("acer", AsList("b1-820", "b1-820", "b1-850", "b1-780", "b1-790", "a1-734", "b3-a30", "b3-a32", "b3-a40", "b3-a40fhd", "b1-870", "b3-a50fhd")),
("ark", AsList("benefit_note 1")),
("dragon link electronics limited", AsList("bb-mobile techno 7.0 lte tq763j")),
("dexp", AsList("dexp ixion e 5", "dexp ixion es 4", "dexp ixion es2 4.5", "dexp ixion ml2 5", "dexp ixion x 4.5", "dexp ixion x 5", "ixion el150 charger", "ixion x250 octava", "ixion xl145 snatch",
               "ixion m155", "ixion x155", "ixion xl145 snatch", "ixion es155", "ixion es245", "ixion m350", "ixion xl140", "ixion xl240", "ixion e145", "ixion m245", "ixion p145 dominator",
               "ixion el350", "ixion ml150", "ixion ms350", "ixion x355", "ixion p135", "ixion p150", "ixion m140", "ixion ms450", "ixion p140", "ixion e240", "ixion es350", "ixion m345",
               "ixion m450", "ixion ms250", "ixion x245", "ixion es260", "ixion es650", "ixion m255", "ixion e250", "ixion es450", "ixion_es255", "ixion e350", "ixion el350", "ixion p350",
               "ixion e245", "ixion p245", "ixion e340", "ixion m240", "ixion ms550", "ixion x150", "ixion es750", "ixion e345", "dexp ursus 10e 3g", "dexp ursus 10m 3g", "ursus 10m2 3g",
               "dexp ursus 10ev 3g", "dexp ursus 7e", "dexp ursus 7e 3g", "dexp ursus 7m2 3g", "dexp ursus 7mv", "dexp ursus 7mv2 3g", "dexp ursus 7mv3 3g", "dexp ursus 7mv4 3g", "dexp ursus 7p",
               "ursus 8e mini", "dexp ursus 8ev", "ursus 8ev2 3g", "dexp ursus 8x 4g", "ursus 9ev mini 3g", "ursus 9px 3g", "ursus_9x3g", "dexp ursus 10e 3g", "dexp ursus 10ev", "ursus a170i",
               "ursus ns110", "dexp al-2020", "dexp al-3020", "ursus g170 hit", "ursus ts170", "ursus ts197 navis", "ld300", "ld303", "ld305", "ursus a170 hit", "ursus g270i", "ursus ns180",
               "ursus a179i", "ursus a270", "ursus a370", "ursus z180", "ursus a210", "ursus a370i", "ursus a470", "ursus ts270", "ursus gx180", "ursus ns170i", "ursus ns210", "ursus ns270",
               "ursus ns310", "ursus ns370", "ursus z280", "ursus z380", "ursus a169", "ursus a169i", "ursus a269", "ursus ts370", "al-1000", "auriga dn750", "kx170", "ursus a110i", "ursus ts180",
               "ursus a310", "ursus ns280", "ursus ns470", "ursus ts210", "ursus kx370", "ursus ts310", "ursus ns370i", "ursus ns470", "ursus a210i", "ursus a310", "ursus ts310", "ursus n110",
               "ursus n170i", "ursus z310", "ursus n180", "ursus p110", "ursus p180", "finepower a2", "s170i", "s270")),
("bb-mobile", AsList("techno-i785ap", "techno 7.0 lte tq763i", "techno i700aj", "techno s700bf")),
("t84p 3g", AsList("oysters t84p 3g")),
("tele2", AsList("tele2 midi", "tele2_midi_1.1", "tele2_midi_1.1", "tele2 maxi")),
("zte", AsList("mflogin4", "blade v7 plus", "avea intouch 4", "avea intouch 4")),
("unknown", AsList("oysters t72x 3g")),
("turbokids", AsList("turbokids s4", "monsterpad", "turbokids de")),
("huawei", AsList("rne-l21", "bnd-l21", "jmm-l22", "lld-l31", "eml-l29", "col-l29", "hma-l29", "cag-l22", "cag-l03", "cag-l23", "lya-l29", "jsn-l21", "bkk-l21", "fig-lx1", "dra-lx5", "pct-l29",
                  "vog-l29", "ele-l29", "mar-lx1m")),
("media pad", AsList("oysters t82p 3g")),
("business bureau", AsList("techno 7.85 3g tm859n")),
("ark electronic technology", AsList("benefit_m502", "benefit_m506", "benefit_s502", "benefit_s503", "benefit_s402", "benefit_s453", "ark benefit m2", "ark benefit m3s", "benefit_s503_max")),
("dns", AsList("dexp_ursus_9pv_3g")),
("oysters t72mr 3g", AsList("oysters t72mr 3g")),
("prestigio", AsList("pmt3608_4g", "pmt3137_3g", "pmt3797_3g", "pmt3777_3g", "pmt3777_3ge", "pmt3767_3g", "pmt3118_3ge", "pmt3318_3ge", "pmt3418_4g", "pmt3418_4ge", "pmt3518_4g", "pmt3518_4ge",
                     "pmt3618_4g", "psp3468duo", "psp3537duo", "psp3528duo", "psp3527duo", "psp7501duo", "psp3511duo", "psp5506duo", "psp3533duo", "psp5530duo", "psp7551duo", "pmt3608_4g",
                     "pmt3137_3g", "pmt3797_3g", "pmt3777_3g", "pmt3777_3ge", "pmt3767_3g", "psp3468duo", "psp3537duo", "psp3528duo", "psp3527duo", "psp7501duo", "psp3533duo", "psp5530duo",
                     "pmt3118_3ge", "pmt3318_3ge", "pmt3418_4g", "pmt3418_4ge", "pmt3518_4g", "pmt3518_4ge", "pmt3618_4g", "psp7551duo", "psp3511duo", "psp5506duo", "psp3517duo", "psp7530duo",
                     "psp5509duo", "psp3508duo", "psp3458duo", "psp3507duo", "psp3506duo", "psp3516duo", "psp5502duo", "psp3510duo", "psp3471duo", "psp3470duo", "psp3423duo", "psp7570duo",
                     "psp7550duo", "psp7512duo", "psp7511duo", "psp7510duo", "psp5552duo", "psp5520duo", "psp5518duo", "psp5515duo", "psp5511duo", "psp5510duo", "psp3552duo", "psp3406duo",
                     "psp3495duo", "psp5522duo", "psp5545duo", "pmt3618_4ge", "pmt1177_4g", "pmt5718_4g", "pmt3708_3g", "pmt3637_4g", "pmt3537_4g", "pmt3437_4g", "pmt3427_3g", "pmt3327_3g",
                     "pmt3317_3g", "pmt3171_3g", "pmt3161_3g", "pmt3157_4g", "pmt3157_3g", "pmt3151_3g", "pmt3101_4g", "psp3517duo", "psp7530duo", "psp5509duo", "psp3508duo", "psp3458duo",
                     "psp3507duo", "psp3506duo", "psp3516duo", "psp5502duo", "psp3510duo", "psp3471duo", "psp3470duo", "psp3423duo", "psp7570duo", "psp7550duo", "psp7512duo", "psp7511duo",
                     "psp7510duo", "psp5552duo", "psp5520duo", "psp5518duo", "psp5515duo", "psp5511duo", "psp5510duo", "psp3552duo", "psp3406duo", "psp3495duo", "psp5522duo", "psp5545duo")),
("vexmobile", AsList("impress_fire", "impress_cube")),
("multilaser", AsList("ms50m", "ms50_4g", "ms55", "ms60", "ms45s", "ms45", "ms50", "ms50m", "ms45s", "ms50m", "ms70", "ms40s", "ms50s", "ms60", "ms55", "m10a", "m7i-3g", "ml11-m7sqc-kidpad")),
("telefunken", AsList("tf-mid804g")),
("turbo", AsList("turbopad 1014")),
("philips", AsList("philips s318", "philips x818")),
("joy", AsList("joy")),
("homtom", AsList("s12")),
("vertex", AsList("impress fortune", "impress lotus", "impress_razor", "impress razor", "impress tor", "impress_wolf", "impress_pear", "impress_spring", "impress_energy", "impress_vega",
                  "impress_wolf", "impress_pear", "impress_forest", "impress_aqua", "impress_disco", "impress_vega", "impress_phonic", "impress_blade", "impress_new", "impress_frost",
                  "impress_spring", "lion_dual")),
("oysters t72x 3g", AsList("oysters t72x 3g")),
("krez", AsList("tm702b4 3g")),
("wexler", AsList("tab8q", "ultima 7", "tab a740", "tab a742", "tab a744", "tab a720", "tab a722", "ultima 7 twist", "ultima 7 octa", "ultima 8 twist", "tab 10q", "mobi 7 lte", "zen 4.5", "tab 7iq",
                 "ultima 7 twist plus", "tab a100", "tab i10", "tab i10+", "tab i80")),
("wileyfox", AsList("swift", "swift 2", "storm")),
("turbopad", AsList("turbopad 723", "turbopad 912", "turbopad 724", "turbopad 1015")),
("alps", AsList("a450", "bb-mobile techno m785an", "oysters t84mri 3g", "oysters t72h 3g", "oysters t84hvi 3g", "oysters t84hri 3g", "oysters t7v 3g", "oysters t72hs 3g", "oysters t72hsi 3g",
                "oysters t72hmi 3g", "oysters t7x 3g", "oysters t72m 3g", "oysters t784hri 3g", "t7v 3g", "sp42", "sp50")),
("sp56", AsList("sp56")),
("spreadtrum", AsList("sp41", "sp 35")),
("digma", AsList("platina 8.3 3g ns8003eg", "optima 7.4 3g tt7024mg", "platina 7.86 3g ns7886mg", "platina 9.7 3g ns9797mg", "plane 7.3 3g ps7003mg", "optima 7.61 tt7061aw",
                 "optima 7.41 3g tt7041mg", "plane 9.7 3g ps9770mg", "optima 7.07 3g tt7007mg", "platina 7.1 4g ns7001ql", "platina 10.2 4g ns1002ql", "platina 8.1 4g ns8001ql", "hit ht7070mg",
                 "optima 7.5 3g tt7025mg", "optima 7.7 3g tt7077mg", "optima 7.77 3g tt7078mg", "idrq10", "idrq10_3g", "idsq10_3g", "idsq11", "idsq11_3g", "idsq7", "idsq7 3g", "idsq7_3g", "idsq8",
                 "idsq8_3g", "linx 4.77 pt474q", "linx 5.5 pt554q", "linx 6.0 ps604m", "optima 10.1 3g tt1040mg", "optima 10.2 3g tt1040mg", "tt4001mg", "optima 7.11 tt7041aw",
                 "optima 7.12 tt7012aw", "tt7025mg", "optima 7.8 tt7026aw", "optima 10.1 3g tt1040mg", "optima 7.61 tt7061aw", "optima_7.8_tt7026aw", "ps1043mg", "plane 10.3 3g ps1043mg",
                 "plane 10.5 3g ps1005mg", "plane 7.1 3g ps7020mg", "plane 7.1 3g car ps7020mg car", "plane 7.2 3g ps7020mg", "plane 8.2 3g ps8040mg", "plane 8.3 3g ps7840mg", "plane 8.4 3g ps8040mg",
                 "ts1012e 3g", "platina 10.1 lte ns1040rl", "platina 7.2 4g ns6902ql", "platina 7.85 3g ns7840mg", "optima 10.1 3g tt1040mg", "plane 10.5 3g ps1005mg", "ps7020mg",
                 "plane 8.2 3g ps8040mg", "plane 8.4 3g ps8040mg", "tt7026mw", "plane 7.4 4g ps7004ml", "hit 4g ht7074ml", "plane 7.5 3g ps7050mg", "optima 8.0 3g tt8000mg", "plane 10.51 3g ps1051mg",
                 "plane 10.6 ps1006rw", "plane 7.6 3g ps7076mg", "plane 7.7 3g ps7007eg", "plane 7.8 3g ps7008eg", "plane 7.71 3g ps7071eg", "optima 8.0 3g tt8000mg", "plane 7.5 3g ps7050mg",
                 "optima 7.08 3g tt7008mg", "optima 10.3 3g tt1003mg", "optima city 3g tt7000mg", "optima 7.09 3g tt7009mg", "plane 7.12 3g ps7012pg", "optima 10.4 3g tt1004pg",
                 "plane 10.7 3g ps1007pg", "optima 10.5 3g tt1005mg", "optima 7.21 3g tt7021pg", "plane 8.5 3g ps8085eg", "optima prime 3g tt7000pg", "optima 7.13 tt7013aw", "optima 10.6 3g tt1006mg",
                 "optima 7.22 3g tt7002mg", "plane 7.9 3g ps7009mg", "plane 8.6 3g ps8086mg", "optima 10.7 tt1007aw", "optima 10.8 ts1008aw", "optima e7.1 3g tt7071mg", "plane e8.1 3g ps8081mg",
                 "plane e10.1 3g ps1010mg", "plane e7.2 3g ps7072pg")),
("fly", AsList("fs509", "fs525", "fs529", "fs528", "fs527", "fs526", "fs530", "mega", "photo pro", "slimline", "view", "life jet", "power plus 5000", "life sky", "life ace")),
("lenovo", AsList("b6000-h", "b8000-h", "lenovo p70")),
("elf electronic technology", AsList("elf_s8")),
("micromax", AsList("micromax q415", "micromax q351", "micromax q397", "micromax q415", "micromax q351", "micromax q397", "q415", "micromax q402+", "micromax q440", "micromax q437",
                    "micromax bharat 5", "micromax q454")),
("ps1043mg", AsList("plane 10.4 3g ps1043mg")),
("krez ltd", AsList("sm503")),
("oysters t72hri 3g", AsList("oysters t72hri 3g")),
("irbis", AsList("tx01", "tx21", "tx22", "tx24", "tx25", "tx26", "tx95", "tx11", "tx12", "tx29", "tx51", "tx52", "tx14", "tx58", "tx59", "tx76", "tx47", "tx49", "tz83", "tz84", "tz11", "tz12", "tz16",
                 "tz21", "tz22", "tz50", "tz51", "tz52", "tz53", "tz85", "tz86", "tz13", "tz14", "tz94", "tz43", "tz70", "tz82", "tz71", "tz10", "tz44", "tx89", "tx90", "tx19", "tx27", "tx28", "tx35",
                 "tz45", "tz72", "tz46", "tz15", "tg74", "tg75", "tg79", "tg97", "tz03", "tz04", "tz05", "tz100", "tz101", "tz102", "tz104", "tz141", "tz142", "tz143", "tz144", "tz161", "tz162",
                 "tz171", "tz19", "tz191", "tz54", "tz55", "tz60", "tz60", "tz62", "tz63l", "tz701", "tz702", "tz703", "tz707", "tz730", "tz731", "tz732", "tz735", "tz736", "tz737", "tz738", "tz761",
                 "tz765", "tz791", "tz80", "tz81l", "tz851", "tz852", "tz853", "tz861", "tz862", "tz863", "tz871", "tz881", "tz891", "tzart", "tzone", "tx60", "tx61", "tz197", "tz897", "tz797",
                 "sp05", "sp06", "sp20", "sp21", "sp43", "sp45", "sp46", "sp52", "sp57", "sp58", "sp59")),
("finepower", AsList("finepower c1", "finepower c2", "finepower c3", "finepower c4", "c6", "finepower d1", "finepower c5", "finepower a1", "finepower b1", "finepower b2", "finepower b3",
                     "finepower a3", "e2", "e1", "e3", "e4", "e5", "n1")),
("pacific800i", AsList("pacific800i")),
("oppo", AsList("cph1803", "cph1809", "cph1893", "cph1907")),
("sony", AsList("h9436", "h4413")),
("nvidia", AsList("oysters t34", "oysters t37")),
("asus", AsList("asus_z00as", "asus_z00as", "asus_x013d", "asus_z01qd", "asus_x00qd", "asus_z01rd", "zs600kl", "zb602kl", "zb631kl", "zb633kl", "zs620kl")),
("oysters", AsList("t72hm3g", "t74hmi_4g", "atlantic454", "indian 254", "pacific454", "pacifice", "antarctice", "pacific4g", "pacifici4g", "pacificvs", "oysters_pacificv", "pacificv", "atlanticv",
                   "arctic450", "atlantic4g", "pacificxl4g", "indianv", "life4g", "t72 md", "oysters t74mri 3g", "t72 mr", "oysters t84m 3g", "oysters t72v 3g", "oysters t102mr 3g",
                   "oysters t102ms 3g", "t84mri 3g", "t74mri 3g", "t72ha 3g", "t104mbi 3g", "t102ms_3g", "t102mr 3g", "t72mr", "t72md", "t72ms", "t72x 3g", "t72mr 3g", "t84hvi 3g", "oysters t14n 3g",
                   "oysters t80 3g", "t82 3g", "t84hvi_3g", "t74er", "t84eri_3g", "t102er 3g", "t72er3g", "t102ms 3g", "t74mr4g", "t74ms", "t72ms3g", "t74mai 3g", "t84hai3g", "t104er4g", "t104mbi_3g",
                   "t72ha_3g", "t84ni_4g", "t84ni_3g", "t74n_3g", "t104b_3g", "t84ni 4g", "t84ni 3g", "t104b_4g", "t84bi_4g", "t74mai_3g", "oysters t72mr 3g", "t74rd", "t104sci_3g", "t74sc_3g",
                   "t74d_3g", "t72n_3g", "t72er 3g", "t102er3g", "oysters t7d 3g", "oysters t72 3g", "oysters t7b 3g", "t62i3g")),
("oysters t104hmi 3g", AsList("oysters t104hmi 3g")),
("4good", AsList("4good s450m 4g", "4good light a103")),
("bq", AsList("bq7008g", "bq1008g", "bq-7010g", "bq-1045g", "bq-9011", "bq-7064g", "bqs-5515", "bqs-5025", "bqs-5004", "bqs-4570", "bqs-4004", "bqs-4800", "bqs-5045", "bqs-5060", "bqs-5050",
              "bqs-5065", "bqs-5520", "bqs-4560", "bqs_5505", "bqs-5030", "bqs-5020", "bqs-5070", "bqs-4503", "bq-4026", "bq-5032", "bq-5033", "bq-5052", "bq-5071", "bq-5082", "bq-6050", "bqs_5505",
              "bqs-5040", "bqs-5045")),
));


$preinstalled_bro_ids = (
    SELECT id, id_type
    FROM `{input_table}`
    WHERE DictContains($preinstalled_bro, String::ToLower(manufacturer)) AND ListHas($preinstalled_bro[String::ToLower(manufacturer)], String::ToLower(model))
);

$preinstalled_searchapp_ids = (
    SELECT id, id_type
    FROM `{input_table}`
    WHERE DictContains($preinstalled_searchapp, String::ToLower(manufacturer)) AND ListHas($preinstalled_searchapp[String::ToLower(manufacturer)], String::ToLower(model))
);

INSERT INTO `{output_table}` WITH TRUNCATE
SELECT id, id_type, 'preinstalled_bro' AS segment_name
FROM $preinstalled_bro_ids
UNION ALL
SELECT id, id_type, 'preinstalled_searchapp' AS segment_name
FROM $preinstalled_searchapp_ids;
"""


class PreinstalledApps(RegularSegmentBuilder):
    name_segment_dict = {
        'preinstalled_bro': 1200,
        'preinstalled_searchapp': 1201,
    }
    keyword = 549

    def requires(self):
        return ExternalInput(config.GAID_ETERNAL)

    def build_segment(self, inputs, output_path):
        self.yql.query(
            query_string=yql_query_template.format(
                input_table=self.input().table,
                output_table=output_path,
            ),
            transaction=self.transaction,
        )
