#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os

from crypta.profile.utils.config import config
from crypta.profile.utils.luigi_utils import AttributeExternalInput
from crypta.profile.utils.segment_utils.builders import RegularSegmentBuilder


select_prism_segments_query = """
INSERT INTO `{output_table}`
WITH TRUNCATE

SELECT
    yandexuid AS id,
    'yandexuid' AS id_type,
    'prism_91_plus' AS segment_name
FROM `{input_table}`
WHERE CAST(cluster AS Uint64) >= 91
UNION ALL
SELECT
    yandexuid AS id,
    'yandexuid' AS id_type,
    'prism_92_plus' AS segment_name
FROM `{input_table}`
WHERE CAST(cluster AS Uint64) >= 92
UNION ALL
SELECT
    yandexuid AS id,
    'yandexuid' AS id_type,
    'prism_96_plus' AS segment_name
FROM `{input_table}`
WHERE CAST(cluster AS Uint64) >= 96
UNION ALL
SELECT
    yandexuid AS id,
    'yandexuid' AS id_type,
    'prism_100' AS segment_name
FROM `{input_table}`
WHERE CAST(cluster AS Uint64) == 100;
"""


class Prism(RegularSegmentBuilder):
    keyword = 557

    name_segment_dict = {
        'prism_91_plus': 19623286,
        'prism_92_plus': 21005806,
        'prism_96_plus': 19447051,
        'prism_100': 19447054,
    }

    def requires(self):
        return AttributeExternalInput(
            table=os.path.join(config.PRISM_OFFLINE_USER_WEIGHTS_DIR, self.date),
            attribute_name='stage',
            attribute_value='full',
        )

    def build_segment(self, inputs, output_path):
        self.yql.query(
            select_prism_segments_query.format(
                input_table=inputs.table,
                output_table=output_path,
            ),
            transaction=self.transaction,
        )
