#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os

from crypta.profile.lib import date_helpers

from crypta.profile.utils.config import config
from crypta.profile.utils.luigi_utils import ExternalInput
from crypta.profile.utils.segment_utils.builders import RegularSegmentBuilder


recent_passport_accounts_query = """
INSERT INTO `{output_table}` WITH TRUNCATE
SELECT
    uid AS id,
    'puid' AS id_type,
    'recent_passport_accounts' AS segment_name
FROM `{input_table}`
WHERE reg_date > {ts_from}
"""


class RecentPassportAccounts(RegularSegmentBuilder):
    keyword = 549
    name_segment_dict = {
        'recent_passport_accounts': 2150,
    }

    def requires(self):
        return ExternalInput(os.path.join(config.PASSPORT_DUMP_DIRECTORY, date_helpers.get_yesterday(self.date)))

    def build_segment(self, inputs, output_path):
        self.yql.query(
            query_string=recent_passport_accounts_query.format(
                input_table=inputs.table,
                ts_from=date_helpers.from_date_string_to_timestamp(date_helpers.get_date_from_past(self.date, 28)),
                output_table=output_path,
            ),
            transaction=self.transaction,
        )
