#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os

from crypta.profile.lib import date_helpers

from crypta.profile.utils.config import config
from crypta.profile.utils.luigi_utils import ExternalInput
from crypta.profile.utils.segment_utils.builders import RegularSegmentBuilder
from crypta.profile.utils.segment_utils.processors import DayProcessor, LogProcessor


SEARCHED_FOR_PHONE_NUMBERS_DIRECTORY = '//home/antispam/procus/daily/phone_search'

get_users_query = """
INSERT INTO `{output_table}` WITH TRUNCATE
SELECT
    id,
    'yandexuid' AS id_type,
    'searched_for_phone_numbers' AS segment_name
FROM (
    SELECT icookie.id1 ?? searched.icookie AS id
    FROM `{input_table}` AS searched
    LEFT JOIN `{icookie_wl}` AS icookie
    ON searched.icookie == icookie.id2
)
GROUP BY id;
"""


class ProcessedReqansForSearchedForPhoneNumbers(DayProcessor):
    def requires(self):
        return ExternalInput(
            os.path.join(
                SEARCHED_FOR_PHONE_NUMBERS_DIRECTORY,
                self.date,
            ),
        )

    def process_day(self, inputs, output_path):
        self.yql.query(
            get_users_query.format(
                input_table=inputs.table,
                icookie_wl=config.ICOOKIE_WL,
                output_table=output_path,
            ),
            transaction=self.transaction,
        )


class SearchedForPhoneNumbers(RegularSegmentBuilder):
    keyword = 549
    name_segment_dict = {
        'searched_for_phone_numbers': 1207,
    }
    number_of_days = 35

    def requires(self):
        return LogProcessor(
            ProcessedReqansForSearchedForPhoneNumbers,
            date_helpers.get_yesterday(self.date),
            self.number_of_days,
        )

    def build_segment(self, inputs, output_path):
        self.yt.unique(
            inputs.table,
            output_path,
            unique_by=('id', 'id_type', 'segment_name')
        )
