#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os

from crypta.profile.utils.luigi_utils import ExternalInput
from crypta.profile.utils.segment_utils.builders import RegularSegmentBuilder
from crypta.profile.utils.segment_utils.processors import DayProcessor, LogProcessor


GEOCUBE_DIR = '//home/geosearch-prod/geocube/1d'

query_template = """
INSERT INTO `{output_table}` WITH TRUNCATE
SELECT DISTINCT
    id,
    id_type,
    'searched_radisson' AS segment_name
FROM (
    SELECT
        id,
        id_type,
        String::ToLower(Yson::ConvertToString(Yson::ConvertToDict(answer)['text'])) as text,
        Yson::ConvertToList(Yson::ConvertToDict(answer)['clicks']) as clicks,
    FROM (
        SELECT
            Yson::ConvertToList(answers_and_clicks) as answer,
            CASE
                WHEN passport_uid IS NOT NULL THEN passport_uid
                ELSE SUBSTRING(yandexuid, 1)
            END AS id,
            CASE
                WHEN passport_uid IS NOT NULL THEN 'puid'
                ELSE 'yandexuid'
            END AS id_type,
        FROM CONCAT(`{maps}`, `{mobile_maps}`)
    )
    FLATTEN LIST BY answer
)
WHERE ListLength(clicks) > 0 AND text LIKE '%radisson%'
"""


class ProcessedReqansForSearchedRadisson(DayProcessor):
    def requires(self):
        return {
            'maps': ExternalInput(os.path.join(GEOCUBE_DIR, self.date, 'maps')),
            'mobile_maps': ExternalInput(os.path.join(GEOCUBE_DIR, self.date, 'mobile_maps')),
        }

    def process_day(self, inputs, output_path):
        self.yql.query(
            query_template.format(
                maps=inputs['maps'].table,
                mobile_maps=inputs['mobile_maps'].table,
                output_table=output_path,
            ),
            transaction=self.transaction,
        )


class SearchedRadisson(RegularSegmentBuilder):
    keyword = 557
    name_segment_dict = {
        'searched_radisson': 18326314,
    }
    number_of_days = 35

    def requires(self):
        return LogProcessor(
            ProcessedReqansForSearchedRadisson,
            self.date,
            self.number_of_days,
        )

    def build_segment(self, inputs, output_path):
        self.yt.unique(
            inputs.table,
            output_path,
            unique_by=('id', 'id_type', 'segment_name')
        )
