#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os

from crypta.profile.utils.config import config
from crypta.profile.utils.luigi_utils import ExternalInput
from crypta.profile.utils.segment_utils.builders import RegularSegmentBuilder
from crypta.profile.utils.segment_utils.processors import DayProcessor, LogProcessor


select_clients_query = """
$sites = AsSet('auth.sape.ru', 'backlink.page-weight.ru', 'backlinksmanager.ru', 'blog.sape.ru', 'blogun.ru',
'buylink.pro', 'checktrust.ru', 'collaborator.pro', 'crowdlinks.megaindex.ru', 'crowdlinks.ru', 'crowd-marketing.pro',
'crowd-master.com.ua', 'crowdpost.ru', 'digimetr.com', 'drivelink.ru', 'e-linker.ru', 'fatlink.ru', 'forumok.com',
'free.miralinks.ru', 'getgoodlinks.ru', 'getmanylinks.ru', 'gochecklinks.net', 'gogetlinks.net', 'gogetlinks.ru',
'gogettop.ru', 'help.miralinks.ru', 'help.sape.ru', 'ingots.ru', 'koloboklinks.com', 'kraud-marketing.by',
'kupilink.com', 'letusindex.com', 'likeberi.com', 'linkbuilder.su', 'linkfeed.ru', 'linkgator.ru', 'linkpad.ru',
'linkparty.ru', 'linkposter.ru', 'links.sape.ru', 'links-shop.com', 'linktolink.ru', 'linkum.ru', 'mainlink.ru',
'maremoto.ru', 'megaindex.com', 'megaindex.ru', 'miralinks.ru', 'natlinks.ru', 'passport.sape.ru', 'postimvse.ru',
'pr.sape.ru', 'proflinks.ru', 'proftrust.ru', 'progoner.ru', 'propage.ru', 'propisun.ru', 'prospero.ru', 'referr.ru',
'rodinalinkov.ru', 'rookee.ru', 'rotapost.ru', 'rt.sape.ru', 'ru.ahrefs.com', 'ru.majestic.com', 'sape.ru',
'sapemaster.ru', 'seogenerator.ru', 'seohammer.ru', 'seopult.pro', 'seopult.ru', 'seo-soft.bigfozzy.com',
'seowizard.ru', 'serv.linkparty.ru', 'setlinks.ru', 'sollomono.ru', 'static.sape.ru', 'trastik.com', 'trust.alaev.info',
'trustlink.ru', 'uniplace.ru', 'vechnyessylki.ru', 'vface.controlstyle.ru', 'webeffector.ru', 'wi8.ru',
'work2crowd.com', 'xtool.ru', 'zapostim.ru', 'zenlink.ru', 'ahrefs.com', 'linkpad.ru', 'majestic.com',
'opensiteexplorer.org', 'ru.majestic.com', 'solomono.ru', '1ps.ru', 'avtoprogon.ru', 'topliv.com',
'client.webeffector.ru', 'promopult.ru', 'movebo.ru', 'pf.megaindex.ru', 'pflink.ru', 'seonly.ru', 'serpclick.ru',
'trafficstore.com', 'userator.ru', 'vpodskazke.ru');

INSERT INTO `{output_table}` WITH TRUNCATE
SELECT host, COUNT(host) as hits, yandexuid
FROM `{input_table}`
WHERE host IN $sites
GROUP BY host, yandexuid;
"""

build_segment_query = u"""
$counted_hits = (
SELECT
    Math::Pow(COUNT(host), 2) * SUM(hits) as metric,
    yandexuid
FROM(
    SELECT host, SUM(hits) as hits, yandexuid
    FROM `{input_table}`
    GROUP BY host, yandexuid)
GROUP BY yandexuid);

INSERT INTO `{output_table}` WITH TRUNCATE
SELECT CAST(yandexuid as String) as id,
       'yandexuid' as id_type,
       'seo_users' as segment_name
FROM $counted_hits
WHERE metric > 3;
"""


class ProcessedMetricsForSeoUsers(DayProcessor):
    def requires(self):
        return ExternalInput(os.path.join(config.METRICS_PARSED_DIR, self.date))

    def process_day(self, inputs, output_path):
        self.yql.query(
            select_clients_query.format(
                input_table=inputs.table,
                output_table=output_path,
            ),
            transaction=self.transaction,
        )


class SeoUsers(RegularSegmentBuilder):

    name_segment_dict = {
        'seo_users': (549, 1641),
    }

    number_of_days = 35

    def requires(self):
        return LogProcessor(ProcessedMetricsForSeoUsers, self.date, self.number_of_days)

    def build_segment(self, inputs, output_path):
        self.yql.query(
            build_segment_query.format(
                input_table=inputs.table,
                output_table=output_path,
            ),
            transaction=self.transaction,
        )
