#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os

from crypta.profile.utils.config import config
from crypta.profile.runners.segments.lib.coded_segments.data.smart_gadgets_market_models_list import MODELS_LIST
from crypta.profile.utils.luigi_utils import ExternalInput
from crypta.profile.utils.segment_utils.builders import RegularSegmentBuilder
from crypta.profile.utils.segment_utils.processors import DayProcessor, LogProcessor


smart_gadgets_customers_query = """
$models_list = AsList({model_list});

INSERT INTO `{output_table}` WITH TRUNCATE
SELECT id, id_type, segment_name
FROM (
    SELECT
        yandex_uid AS id,
        'yandexuid' AS id_type,
        'smart_gadgets_customers' AS segment_name
    FROM `{input_table}`
    WHERE yandex_uid IS NOT NULL AND (category_id == 70 OR hyper_id IN $models_list)
)
GROUP BY id, id_type, segment_name
"""


class MarketShowsLogForSmartGadgetsCustomers(DayProcessor):
    def requires(self):
        return ExternalInput(os.path.join(config.MARKET_SHOW_LOG_FOLDER, self.date))

    def process_day(self, inputs, output_path):
        self.yql.query(
            smart_gadgets_customers_query.format(
                input_table=inputs.table,
                output_table=output_path,
                model_list=', '.join([str(model_id) for model_id in MODELS_LIST]),
            ),
            transaction=self.transaction,
        )


class SmartGadgetsCustomers(RegularSegmentBuilder):
    name_segment_dict = {
        'smart_gadgets_customers': 535,
    }

    keyword = 216
    number_of_days = 7

    def requires(self):
        return {
            'MarketShowsLog': LogProcessor(
                MarketShowsLogForSmartGadgetsCustomers,
                self.date,
                self.number_of_days,
            ),
        }

    def build_segment(self, inputs, output_path):
        self.yt.unique(
            [inputs['MarketShowsLog'].table],
            output_path,
            unique_by=['id', 'id_type', 'segment_name'],
        )
