#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os

from crypta.profile.utils.config import config
from crypta.profile.utils.luigi_utils import ExternalInput
from crypta.profile.utils.segment_utils.builders import RegularSegmentBuilder
from crypta.profile.utils.segment_utils.processors import DayProcessor, LogProcessor


videobloggers_market_query = u"""
$re = Hyperscan::Grep('(зеленый экран|хромакей|фотофон|кольцевая лампа|свет для блогера|led прожектор|\
greenbean fresnel 300|sennheiser ew 345-g3-a|накамерный источник света|cтойка для осветительных приборов|cофтбокс|\
микрофон-пушка|конденсаторный микрофон|импульсный проводной микрофон|накамерный микрофон|поп-фильтр|держатель паук|\
штатив|монопод|камера gopro|canon eos 5d mark IV).*');


INSERT INTO `{output_table}` WITH TRUNCATE
SELECT
    id,
    'yandexuid' AS id_type,
    'video_blogers' AS segment_name
FROM (
    SELECT yandex_uid AS id
    FROM `{input_table}`
    WHERE yandex_uid IS NOT NULL AND $re(normalized_to_lower_query)
)
GROUP BY id
"""


class MarketShowsLogForVideobloggers(DayProcessor):
    def requires(self):
        return ExternalInput(
            os.path.join(
                config.MARKET_SHOW_LOG_FOLDER,
                self.date,
            ),
        )

    def process_day(self, inputs, output_path):
        self.yql.query(
            videobloggers_market_query.format(
                input_table=inputs.table,
                output_table=output_path,
            ),
            transaction=self.transaction,
        )


class Videobloggers(RegularSegmentBuilder):
    name_segment_dict = {
        'video_blogers': 15797989,
    }

    keyword = 557
    number_of_days = 35

    def requires(self):
        return {
            'MarketShowsLog': LogProcessor(
                MarketShowsLogForVideobloggers,
                self.date,
                self.number_of_days,
            ),
        }

    def build_segment(self, inputs, output_path):
        self.yt.unique(
            inputs['MarketShowsLog'].table,
            output_path,
            unique_by=['id', 'id_type', 'segment_name'],
        )
