import datetime
import os

import luigi

from crypta.lib.python import templater
from crypta.lib.python.yt import yt_helpers
from crypta.profile.utils import luigi_utils
from crypta.profile.utils.config import config


class BuildIndex(luigi_utils.BaseYtTask):
    date = luigi.Parameter()
    input_dir = luigi.Parameter()
    index_dir = luigi.Parameter()
    query_resource = None

    def requires(self):
        return luigi_utils.ExternalInput(os.path.join(self.input_dir, self.date))

    def output(self):
        return luigi_utils.YtTarget(os.path.join(self.index_dir, self.date))

    def run(self):
        query_string = templater.render_resource(self.query_resource, strict=True, vars={
            'input': self.input().table,
            'output': self.output().table,
        })

        with self.yt.Transaction() as tx:
            self.yql.query(query_string, transaction=tx, erasure_codec="none")
            yt_helpers.set_ttl(self.output().table, datetime.timedelta(days=config.NUMBER_OF_DAYS_TO_KEEP_PARSED_LOGS), self.yt)
