import argparse
import functools
import logging
import os

from crypta.lib.python.logging import logging_helpers
from crypta.lib.python.yql import client as yql_helpers
from crypta.lib.python.yt import yt_helpers
from crypta.profile.runners.vectors_update.lib import (
    app2vec,
    site2vec,
)
from crypta.profile.runners.vectors_update.lib.utils import config


logger = logging.getLogger(__name__)


def main():
    logging_helpers.configure_stderr_logger(logging.getLogger(), level=logging.INFO)
    logger.info('vectors update')

    yt_client = yt_helpers.get_yt_client(
        yt_proxy=config.CRYPTA_YT_PROXY,
        yt_pool=config.DEFAULT_POOL,
        yt_token=os.environ['YT_TOKEN']
    )

    yql_client = yql_helpers.create_yql_client(
        yt_proxy=config.CRYPTA_YT_PROXY,
        pool=config.DEFAULT_POOL,
        token=os.environ["YQL_TOKEN"],
    )

    tasks_dict = {
        'update_app2vec': functools.partial(app2vec.update, yt_client=yt_client, yql_client=yql_client),
        'update_site2vec': functools.partial(site2vec.update, yt_client=yt_client, yql_client=yql_client),
    }

    parser = argparse.ArgumentParser()
    parser.add_argument('job_name', type=str, help=' / '.join(tasks_dict.keys()))
    args = parser.parse_args()

    if args.job_name in tasks_dict:
        logger.info('Job name {} is started'.format(args.job_name))
        tasks_dict[args.job_name]()
        logger.info('Job name {} is successfully finished'.format(args.job_name))
    else:
        logger.warn('Unknown job_name "{}"'.format(args.job_name))
        exit(1)

if __name__ == '__main__':
    main()
