import argparse
import logging

from crypta.lib.python import yaml_config
from crypta.lib.python.logging import logging_helpers
from crypta.lib.python.proto_secrets import proto_secrets
from crypta.profile.services.calc_lab_segments_stats.lib import runner
from crypta.profile.services.calc_lab_segments_stats.proto.config_pb2 import TConfig


logger = logging.getLogger(__name__)


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument("--config", required=True)
    return parser.parse_args()


def main():
    logging_helpers.configure_stdout_logger(logging.getLogger())
    args = parse_args()
    config = yaml_config.parse_config(TConfig, args.config)
    logger.info("Config:\n{}".format(proto_secrets.get_copy_without_secrets(config)))

    runner.calc_stats(config, logger)

    logger.info("Completed successfully")
