import datetime

from yt.wrapper import ypath

from crypta.buchhalter.services.main.lib.common.helpers import tables_helpers
from crypta.lib.python.yql import yql_helpers
from crypta.lib.python.yt import yt_helpers
from crypta.lib.python.yt.processed_tables_tracker import ProcessedTablesTracker


def calc_stats(config, logger):
    yt_client = yt_helpers.get_yt_client(config.Yt.Proxy, config.Yt.Pool)

    tracker = ProcessedTablesTracker(config.DirectRetargeting)

    while True:
        with yt_client.Transaction() as tx:
            date = tables_helpers.get_unprocessed_date(
                yt_client,
                tracker,
                [config.DirectMultipliersDir, config.AdfoxDir],
                logger,
            )
            if date is None:
                break

            logger.info("Processing date: %s", date)

            params = {
                "date": date,
                "direct_retargeting_dir": config.DirectRetargeting.SourceDir,
                "direct_multipliers_dir": config.DirectMultipliersDir,
                "adfox_dir": config.AdfoxDir,
                "segments_table": config.SegmentsTable,
                "export_stats_dir": config.ExportsStatsDir,
            }

            yql_helpers.run_query("/query/calc_stats.yql", config.Yt, params, logger, tx=tx)

            direct_retargeting_table_path = ypath.ypath_join(config.DirectRetargeting.SourceDir, date)
            tracker.add_processed_tables(yt_client, [direct_retargeting_table_path])

        yt_helpers.set_ttl(ypath.ypath_join(config.ExportsStatsDir, date), datetime.timedelta(days=config.TtlDays), yt_client, remove_if_empty=True)
