from yt import yson


ASCENDING = u'ascending'
ITEM = u'item'
NAME = u'name'
REQUIRED = u'required'
SORT_ORDER = u'sort_order'
STRICT = u'strict'
TYPE = u'type'
TYPE_NAME = u'type_name'
TYPE_V3 = u'type_v3'
UNIQUE_KEYS = u'unique_keys'

BOOLEAN = u'boolean'
INT64 = u'int64'
LIST = u'list'
STRING = u'string'

LIST_OF_STRINGS = {
    TYPE_NAME: LIST,
    ITEM: STRING,
}

EXPORT_ID = u'export_id'
KEYWORD_ID = u'keyword_id'
SEGMENT_ID = u'segment_id'
CATEGORY = u'category'
IS_BASED_ON_SOCDEM = u'is_based_on_socdem'
IS_BASED_ON_LAL = u'is_based_on_lal'
IS_BASED_ON_CODE = u'is_based_on_code'
IS_BASED_ON_YT_TABLE = u'is_based_on_yt_table'
SOURCES_SOCDEM = u'sources_socdem'
SOURCES_LAL = u'sources_lal'
SOURCES_CODE = u'sources_code'
SOURCES_YT_TABLE = u'sources_yt_table'
HUMAN_READABLE_SOCDEM_NAMES = u'human_readable_socdem_names'


def get_ml_table_schema():
    schema = yson.YsonList([
        {
            NAME: EXPORT_ID,
            TYPE: STRING,
            REQUIRED: True,
            SORT_ORDER: ASCENDING,
        },
        {
            NAME: KEYWORD_ID,
            TYPE: INT64,
            REQUIRED: True,
        },
        {
            NAME: SEGMENT_ID,
            TYPE: INT64,
            REQUIRED: True,
        },
        {
            NAME: CATEGORY,
            TYPE: STRING,
            REQUIRED: True,
        },
        {
            NAME: IS_BASED_ON_SOCDEM,
            TYPE: BOOLEAN,
            REQUIRED: True,
        },
        {
            NAME: IS_BASED_ON_LAL,
            TYPE: BOOLEAN,
            REQUIRED: True,
        },
        {
            NAME: IS_BASED_ON_CODE,
            TYPE: BOOLEAN,
            REQUIRED: True,
        },
        {
            NAME: IS_BASED_ON_YT_TABLE,
            TYPE: BOOLEAN,
            REQUIRED: True,
        },
        {
            NAME: SOURCES_SOCDEM,
            TYPE_V3: LIST_OF_STRINGS,
        },
        {
            NAME: SOURCES_LAL,
            TYPE_V3: LIST_OF_STRINGS,
        },
        {
            NAME: SOURCES_CODE,
            TYPE_V3: LIST_OF_STRINGS,
        },
        {
            NAME: SOURCES_YT_TABLE,
            TYPE_V3: LIST_OF_STRINGS,
        },
        {
            NAME: HUMAN_READABLE_SOCDEM_NAMES,
            TYPE_V3: LIST_OF_STRINGS,
        },
    ])

    schema.attributes[STRICT] = True
    schema.attributes[UNIQUE_KEYS] = True

    return schema
