import argparse
import logging
import os

from crypta.lib.python import yaml_config
from crypta.lib.python.custom_ml.samples.new_sample import add_new_sample_for_existing_industry
from crypta.lib.python.logging import logging_helpers
from crypta.lib.python.proto_secrets import proto_secrets
import crypta.lib.python.yql.client as yql_helpers
from crypta.lib.python.yt import yt_helpers
from crypta.profile.services.merge_new_trainable_segments_sample.proto.config_pb2 import TConfig

logger = logging.getLogger(__name__)


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('--config', required=True)
    return parser.parse_args()


def main():
    logging_helpers.configure_stdout_logger(logging.getLogger())
    args = parse_args()
    config = yaml_config.parse_config(TConfig, args.config)
    logger.info('Config:\n{}'.format(proto_secrets.get_copy_without_secrets(config)))

    yt_client = yt_helpers.get_yt_client(
        yt_proxy=config.Yt.Proxy,
        yt_pool=config.Yt.Pool,
        yt_token=config.Yt.Token,
    )

    yql_client = yql_helpers.create_yql_client(
        yt_proxy=config.Yt.Proxy,
        pool=config.Yt.Pool,
        token=os.getenv('YQL_TOKEN'),
    )

    add_new_sample_for_existing_industry(
        yt_client=yt_client,
        yql_client=yql_client,
        industry_model_name=config.ModelName,
        new_sample_by_puid_table=config.NewSampleByPuidPath,
        partner=config.Partner,
        login=config.Login,
        logger=logger,
        add_to_training=config.AddToTraining,
        retrain_model=config.RetrainModel,
        use_addition_date=config.UseAdditionDate,
    )

    logger.info('Completed successfully')
