import argparse
import logging

from crypta.lib.python import yaml_config
from crypta.lib.python.logging import logging_helpers
from crypta.lib.python.proto_secrets import proto_secrets
from crypta.profile.services.precalculate_tables.tasks import (
    electrocars,
    travel,
    travelers_to_moscow_with_night_stay,
    uslugi_contractors,
    zodiac_signs,
)
from crypta.profile.services.precalculate_tables.lib.common.config_pb2 import TConfig


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument("--config", required=True)

    subparsers = parser.add_subparsers()
    electrocars.add_args_subparser(subparsers)
    travel.add_args_subparser(subparsers)
    travelers_to_moscow_with_night_stay.add_args_subparser(subparsers)
    zodiac_signs.add_args_subparser(subparsers)
    uslugi_contractors.add_args_subparser(subparsers)

    return parser.parse_args()


def main():
    logging_helpers.configure_stdout_logger(logging.getLogger())
    logger = logging.getLogger(__name__)

    args = parse_args()
    logger.info("Args: %s", args)

    config = yaml_config.parse_config(TConfig, args.config)
    logger.info("Config:\n%s", proto_secrets.get_copy_without_secrets(config))

    function = args.function

    kwargs = vars(args)
    del kwargs["function"]
    del kwargs["config"]

    function(config, logger, **kwargs)

    logger.info("Completed successfully")
