import yt.wrapper as yt

from crypta.lib.python import time_utils
from crypta.lib.python.yql import yql_helpers
from crypta.lib.python.yt import yt_helpers
from crypta.lib.python.yt.processed_tables_tracker import ProcessedTablesTracker


def add_args_subparser(subparsers):
    parser = subparsers.add_parser("electrocars")
    parser.set_defaults(function=run)


def expand(path):
    return [yt.ypath_join(path, table) for table in ["maps", "navi", "mobile_maps", "touch_maps", "serp"]]


def run(config, logger):
    yt_client = yt_helpers.get_yt_client(config.Yt.Proxy, config.Yt.Pool)
    tracker = ProcessedTablesTracker(config.GeocubeProdLog)

    while True:
        with yt_client.Transaction() as tx:
            src_dir_paths = tracker.get_unprocessed_tables(yt_client, 30)

            if not src_dir_paths:
                logger.info("No tables to process")
                break

            src_table_paths = sum([expand(path) for path in src_dir_paths], [])
            src_table_paths = [x for x in src_table_paths if yt_client.exists(x)]

            yql_helpers.run_query(
                query_template="/query/electrocars.yql",
                yt_config=config.Yt,
                query_params={
                    "input_tables": src_table_paths,
                    "min_ts": int(time_utils.get_current_time()) - config.ElectroCarsAgeSec,
                    "matching_table": config.IndeviceYandexuidMatchingTable,
                    "output_table": config.ElectroCarsTable,
                },
                logger=logger,
                tx=tx,
            )

            tracker.add_processed_tables(yt_client, src_dir_paths)
