from crypta.lib.python import time_utils
from crypta.lib.python.yql import yql_helpers
from crypta.lib.python.yt import yt_helpers
from crypta.lib.python.yt.processed_tables_tracker import ProcessedTablesTracker


def add_args_subparser(subparsers):
    parser = subparsers.add_parser("travel")
    parser.set_defaults(function=run)


def run(config, logger):
    yt_client = yt_helpers.get_yt_client(config.Yt.Proxy, config.Yt.Pool)
    tracker = ProcessedTablesTracker(config.RaspUsersSearchLog)

    while True:
        with yt_client.Transaction() as tx:
            src_table_paths = tracker.get_unprocessed_tables(yt_client, 30)

            if not src_table_paths:
                logger.info("No tables to process")
                break

            yql_helpers.run_query(
                query_template="/query/travel.yql",
                yt_config=config.Yt,
                query_params={
                    "input_tables": src_table_paths,
                    "min_travel_ts": int(time_utils.get_current_time()),
                    "crypta_identifier_udf_url": config.CryptaIdentifierUdfUrl,
                    "matching_table": config.CryptaIdMatchingTable,
                    "regions_table": config.CryptaIdRegionsTable,
                    "rasp_station_table": config.RaspStationTable,
                    "rasp_settlement_table": config.RaspSettlementTable,
                    "countries_dir": config.TravelCountriesDir,
                    "cities_dir": config.TravelCitiesDir,
                    "regions_dir": config.TravelRegionsDir,
                    "types_of_trip_dir": config.TypesOfTripDir,
                    "future_trips_table": config.FutureTripsTable,
                    "hotels_table": config.HotelsTable,
                },
                logger=logger,
                tx=tx,
            )

            tracker.add_processed_tables(yt_client, src_table_paths)
