from datetime import timedelta

from crypta.lib.python import time_utils
from crypta.lib.python.yql import yql_helpers


def add_args_subparser(subparsers):
    parser = subparsers.add_parser("travelers_to_moscow_with_night_stay")
    parser.set_defaults(function=run)


def run(config, logger):
    yql_query_params = {
        "weekly_travelers_dir": config.WeeklyTravelersDir,
        "vertices_no_multi_profile_table": config.VerticesNoMultiProfileTable,
        "crypta_id_regions_table": config.CryptaIdRegionsTable,
        "date_year_ago": _date_year_ago(),
        "output_dir": config.TravelersToMoscowWithNightStayDir,
    }
    yql_helpers.run_query("/query/travelers_to_moscow_with_night_stay.yql", config.Yt, yql_query_params, logger)


def _date_year_ago():
    dt = time_utils.get_current_moscow_datetime() - timedelta(days=365)
    return dt.strftime("%Y-%m-%d")
