from crypta.lib.python.yql import yql_helpers


def add_args_subparser(subparsers):
    parser = subparsers.add_parser("uslugi_contractors")
    parser.set_defaults(function=run)


def run(config, logger):
    query_params = {
        "occupations_table": config.UslugiContractorOccupationsTable,
        "puids_table": config.UslugiContractorPuidsTable,
        "output_dir": config.UslugiContractorsDir,
        'common_occupations': {
            "repetitory": '/repetitory-i-obucenie',
            "krasota": '/krasota',
            "uristy": '/uristy',
            "trenery": '/trenery',
            "photo_video": '/foto-i-video',
            "tvorchestro": '/tvorcestvo,-rukodelie-i-hobbi',
            "meroprijatija": '/organizazia-meropriatij',
            "zhivontyje": '/uslugi-dla-jivotnyh',
            "psiholog": '/raznoe/psiholog',
            "perevodchik": '/raznoe/perevodcik',
            "kopirajter": '/raznoe/kopirajter',
            "konsalting": '/raznoe/biznes-konsalting',
            "psihiatr": '/raznoe/psihiatr',
            "geraldika_i_geneologija": '/raznoe/geral_dika-i-genealogia',
            "melkaa_bytovaa_tehnika": '/remont-i-ustanovka-tehniki/melkaa-bytovaa-tehnika',
        },
        'particular_occupations': {
            "marketolog": '/raznoe/internet-marketolog',
            "smm": '/raznoe/internet-marketolog/smm-prodvijenie',
            "email_marketing": '/raznoe/internet-marketolog/email-marketing',
            "posting": '/raznoe/internet-marketolog/uslugi-postinga',
            "graficeskij_dizajner": '/dizajnery/graficeskij-dizajner',
            "veb_dizajner": '/dizajnery/veb-dizajner',
            "kuhonnye_plity": '/remont-i-ustanovka-tehniki/kuhonnye-plity',
            "posudomoecnye_masiny": '/remont-i-ustanovka-tehniki/posudomoecnye-masiny',
            "stiral_nye_masiny": '/remont-i-ustanovka-tehniki/stiral_nye-masiny',
            "televizory": '/remont-i-ustanovka-tehniki/televizory',
            "sushilki": '4446',
            "filtry_vody": '5359',
            "cofemachine": '5361',
            "vytyazhki": '5364',
            "printers": '5366',
            "domophones": '5368',
        }
    }
    yql_helpers.run_query(
        "/query/contractors.yql",
        config.Yt, query_params, logger
    )
