try:
    import cPickle as pickle
except:
    import pickle
from datetime import datetime
import functools
import json

from library.python import resource

from crypta.lib.python import (
    templater,
    yaml_config,
)
from crypta.lib.python.nirvana.nirvana_helpers.nirvana_transaction import NirvanaTransaction
from crypta.lib.python.yt import yt_helpers
from crypta.profile.lib.socdem_helpers import socdem_config
from crypta.profile.lib.socdem_helpers.simple_nn import SimpleNN
from crypta.profile.services.train_socdem_models.proto.config_pb2 import TConfig


def get_yaml_config(parameters):
    parameters['date'] = datetime.fromtimestamp(int(parameters['timestamp'])).strftime('%Y-%m-%d')
    template_config = resource.find('/training/config.yaml').decode('utf-8')
    rendered_config = templater.render_template(
        template_config,
        vars=parameters,
    )

    return rendered_config


def get_proto_config(parameters):
    config_for_training = TConfig()
    yaml_config.yaml2proto.yaml2proto(get_yaml_config(parameters), config_for_training)
    return config_for_training


def get_inputs(nv_context):
    inputs = nv_context.get_inputs()

    nn_models = []
    for socdem_type in socdem_config.SOCDEM_TYPES:
        if inputs.has('{}_nn_model'.format(socdem_type)):
            nn_model_input_file = inputs.get('{}_nn_model'.format(socdem_type))
            with open(nn_model_input_file, 'rb') as model_file_to_load:
                model = pickle.load(model_file_to_load)
                assert isinstance(model, SimpleNN)
                nn_models.append(model)

    if inputs.has('features_dict'):
        dict_input_file = inputs.get('features_dict')
        with open(dict_input_file, 'r') as dict_file:
            dict_input = json.load(dict_file)
    else:
        dict_input = None

    return nn_models, dict_input


def get_outputs(nv_context):
    outputs = nv_context.get_outputs()
    nn_model_output_file = None if not outputs.has('nn_model') else outputs.get('nn_model')
    dict_output_file = None if not outputs.has('features_dict') else outputs.get('features_dict')

    return nn_model_output_file, dict_output_file


def replace_table(yt_client, testing_table_path, sample_size=2e5):
    yt_helpers.make_sample_with_size(
        yt_client=yt_client,
        source_table=testing_table_path.replace('testing', 'production'),
        destination_table=testing_table_path,
        size=sample_size,
    )


def wrap_with_nirvana_transaction(yt_client, func):
    with NirvanaTransaction(yt_client) as transaction:
        return functools.partial(func, transaction=transaction)
