import argparse
import logging

from crypta.lib.python import yaml_config
from crypta.lib.python.logging import logging_helpers
from crypta.lib.python.proto_secrets import proto_secrets
from crypta.profile.services.upload_direct_exports_tanker_names_to_yt.lib import UploadDirectExportsTankerKeysToYt
from crypta.profile.services.upload_direct_exports_tanker_names_to_yt.proto.config_pb2 import TConfig


logger = logging.getLogger(__name__)


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument("--config", required=True)
    return parser.parse_args()


def main():
    logging_helpers.configure_stdout_logger(logging.getLogger())
    args = parse_args()
    config = yaml_config.parse_config(TConfig, args.config)
    logger.info("Config:\n{}".format(proto_secrets.get_copy_without_secrets(config)))

    UploadDirectExportsTankerKeysToYt(config, logger).run()

    logger.info("Completed successfully")
