from crypta.lib.python.spine.consts import environment


ENVS = {
    environment.TESTING: environment.TESTING.upper(),
    environment.STABLE: environment.PRODUCTION.upper(),
}


class UniversalTask(object):
    def __init__(
        self,
        bundle_name,
        binary,
        kill_timeout,
        crit_time,
        aggr_hosts,
        subprogram=None,
        schedule_interval=None,
        schedule_daily_start_time=None,
        retry_interval=None,
        sequential_run=True,
        use_semaphore=True,
        requirements=None,
    ):
        self.bundle_name = bundle_name
        self.binary = binary
        self.kill_timeout = kill_timeout
        self.crit_time = crit_time
        self.aggr_hosts = aggr_hosts
        self.subprogram = subprogram
        self.schedule_daily_start_time = schedule_daily_start_time
        self.schedule_interval = schedule_interval
        self.retry_interval = retry_interval
        self.sequential_run = sequential_run
        self.use_semaphore = use_semaphore
        self.requirements = requirements


def create_run_universal_bundle_schedulers(sandbox, task):
    for aggr_host in task.aggr_hosts:
        scheduler = sandbox.create_run_universal_bundle_scheduler(
            bundle_name=task.bundle_name,
            cmd=_cmd(task.binary, task.subprogram),
            templates=[],
            env=aggr_host.environment,
            juggler_service=sandbox_juggler_service(task.bundle_name, task.subprogram),
            additional_env={
                "CRYPTA_ENVIRONMENT": ENVS[aggr_host.environment].lower(),
            },
            secrets_env={
                "YAV_TOKEN": "sec-01cw472jke1g9aw0bgt08w5b1r[token]",
            },
            schedule_interval=task.schedule_interval,
            schedule_daily_start_time=task.schedule_daily_start_time,
            retry_interval=task.retry_interval,
            kill_timeout=task.kill_timeout,
            semaphore_name=sandbox_semaphore_name(task.bundle_name, task.subprogram, aggr_host.environment),
            use_semaphore=task.use_semaphore,
            sequential_run=task.sequential_run,
            requirements=task.requirements,
        )
        if task.crit_time is not None:
            scheduler.check(crit_time=task.crit_time).set_host(aggr_host.host)


def _cmd(binary, subprogram=None):
    cmd = ["{{{{cwd}}}}/{binary}".format(binary=binary)]

    if subprogram is not None:
        cmd.append(subprogram)

    cmd.append("--log-file-path={{logdir}}")

    return cmd


def sandbox_juggler_service(bundle_name, subprogram=None):
    return bundle_name if subprogram is None else "{}-{}".format(bundle_name, subprogram)


def sandbox_semaphore_name(bundle_name, subprogram, environment):
    return "CryptaRunUniversalBundle_{}_{}_{}".format(bundle_name, subprogram, environment)
